/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.dto.EipDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;

public class CamelEipsCompleter
implements UICompleter<EipDto> {
    private final Project project;
    private final CamelCatalog camelCatalog;
    private final Dependency core;

    public CamelEipsCompleter(Project project, CamelCatalog camelCatalog) {
        this.project = project;
        this.camelCatalog = camelCatalog;
        this.core = CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    public Iterable<EipDto> getCompletionProposals(UIContext context, InputComponent input, String value) {
        if (this.core == null) {
            return null;
        }
        ArrayList<EipDto> answer = new ArrayList<EipDto>();
        List names = this.camelCatalog.findModelNames();
        ArrayList<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (value != null && !name.startsWith(value)) continue;
            filtered.add(name);
        }
        for (String name : filtered) {
            String json = this.camelCatalog.modelJSonSchema(name);
            EipDto dto = CamelCatalogHelper.createEipDto(this.camelCatalog, json);
            answer.add(dto);
        }
        return answer;
    }

    public Iterable<EipDto> getValueChoices(String label) {
        if (this.core == null) {
            return null;
        }
        List<String> names = this.camelCatalog.findModelNames();
        if (label != null && !"<all>".equals(label)) {
            names = this.filterByLabel(names, label);
        }
        ArrayList<EipDto> answer = new ArrayList<EipDto>();
        for (String name : names) {
            EipDto dto = CamelCatalogHelper.createEipDto(this.camelCatalog, name);
            answer.add(dto);
        }
        return answer;
    }

    private List<String> filterByLabel(List<String> choices, String label) {
        if (label == null || label.isEmpty()) {
            return choices;
        }
        ArrayList<String> answer = new ArrayList<String>();
        block0: for (String name : choices) {
            String json = this.camelCatalog.modelJSonSchema(name);
            String labels = CamelEipsCompleter.findLabel(json);
            if (labels != null) {
                for (String target : labels.split(",")) {
                    if (!target.startsWith(label)) continue;
                    answer.add(name);
                    continue block0;
                }
                continue;
            }
            answer.addAll(choices);
        }
        return answer;
    }

    private static String findLabel(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"model", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("label") == null) continue;
            return (String)row.get("label");
        }
        return null;
    }
}

