/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.completer.PackageNameCompleter;
import io.fabric8.forge.addon.utils.validator.ClassNameValidator;
import io.fabric8.forge.addon.utils.validator.PackageNameValidator;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureComponentPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderCompleter;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CollectionHelper;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ClassLoaderFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.facets.HintsFacet;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.jboss.forge.roaster.model.util.Strings;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class, ClassLoaderFacet.class})
public class CamelNewComponentCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="Component Name", required=true, description="The component to use")
    private UISelectOne<ComponentDto> componentName;
    @Inject
    @WithAttributes(label="Instance Name", required=true, description="Name of component instance to add")
    private UIInput<String> instanceName;
    @Inject
    @WithAttributes(label="Target Package", required=false, description="The package name where this type will be created")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="Class Name", required=false, description="The class name to create")
    private UIInput<String> className;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelNewComponentCommand.class).name("Camel: New Component").category(Categories.create((String[])new String[]{CATEGORY})).description("Creates a new Camel component configured in Java code");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.configureComponentName(project, this.componentName, false, false);
        this.targetPackage.setCompleter((UICompleter)new PackageNameCompleter(facet));
        this.targetPackage.addValidator((UIValidator)new PackageNameValidator());
        ((HintsFacet)this.targetPackage.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_PACKAGE_PICKER");
        Set<String> packages = new RouteBuilderCompleter(facet).getPackages();
        if (packages.size() == 1) {
            this.targetPackage.setDefaultValue((Object)CollectionHelper.first(packages));
        }
        this.className.addValidator((UIValidator)new ClassNameValidator(false));
        ((HintsFacet)this.className.getFacet(HintsFacet.class)).setInputType("org.jboss.forge.inputType.JAVA_CLASS_PICKER");
        builder.add(this.componentName).add(this.instanceName).add(this.targetPackage).add(this.className);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        String camelComponentName = ((ComponentDto)this.componentName.getValue()).getScheme();
        attributeMap.put("componentName", camelComponentName);
        attributeMap.put("instanceName", this.instanceName.getValue());
        attributeMap.put("targetPackage", this.targetPackage.getValue());
        String name = (String)this.className.getValue();
        if (Strings.isBlank((String)name)) {
            name = Strings.capitalize((String)((String)this.instanceName.getValue())) + "ComponentFactory";
        }
        attributeMap.put("className", name);
        boolean cdi = CamelCommandsHelper.isCdiProject(this.getSelectedProject((UIContextProvider)context));
        boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject((UIContextProvider)context));
        if (cdi) {
            attributeMap.put("kind", "cdi");
        } else if (spring) {
            attributeMap.put("kind", "spring");
        } else {
            attributeMap.put("kind", "java");
        }
        String previous = (String)attributeMap.get("componentName");
        if (previous != null && previous.equals(camelComponentName) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, MAX_OPTIONS, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureComponentPropertiesStep step = new ConfigureComponentPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

