/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelComponentDetails;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.helper.LineNumberHelper;
import io.fabric8.forge.camel.commands.project.helper.StringHelper;
import io.fabric8.forge.camel.commands.project.helper.UIHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.model.util.Strings;

public class ConfigureEditEndpointPropertiesStep
extends AbstractCamelProjectCommand
implements UIWizardStep {
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;
    private List<InputComponent> inputs = new ArrayList<InputComponent>();

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureEditEndpointPropertiesStep.class).name("Camel: Edit Endpoint XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Configure the endpoint options to use");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map currentValues;
        String json;
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        Map attributeMap = builder.getUIContext().getAttributeMap();
        String camelComponentName = ConfigureEditEndpointPropertiesStep.optionalAttributeValue(attributeMap, "componentName");
        String uri = ConfigureEditEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "endpointUri");
        if (camelComponentName == null && uri != null) {
            camelComponentName = CamelCatalogHelper.endpointComponentName(uri);
        }
        if ((json = catalog.componentJSonSchema(camelComponentName)) == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        Map map = currentValues = uri != null ? catalog.endpointProperties(uri) : Collections.EMPTY_MAP;
        if (data != null) {
            HashSet<String> namesAdded = new HashSet<String>();
            for (Map propertyMap : data) {
                InputComponent input;
                Class<Object> inputClazz;
                String name = (String)propertyMap.get("name");
                String kind = (String)propertyMap.get("kind");
                String type = (String)propertyMap.get("type");
                String javaType = (String)propertyMap.get("javaType");
                String deprecated = (String)propertyMap.get("deprecated");
                String required = (String)propertyMap.get("required");
                String currentValue = (String)currentValues.get(name);
                String defaultValue = (String)propertyMap.get("defaultValue");
                String description = (String)propertyMap.get("description");
                String enums = (String)propertyMap.get("enum");
                if (Strings.isNullOrEmpty((String)name) || (inputClazz = CamelCommandsHelper.loadValidInputTypes(javaType, type)) == null || !namesAdded.add(name) || (input = UIHelper.createUIInput(this.componentFactory, this.getConverterFactory(), name, inputClazz, required, currentValue, defaultValue, enums, description)) == null) continue;
                builder.add(input);
                this.inputs.add(input);
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        String kind = ConfigureEditEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "kind");
        if ("xml".equals(kind)) {
            return this.executeXml(context, attributeMap);
        }
        return Results.success();
    }

    protected Result executeXml(UIExecutionContext context, Map<Object, Object> attributeMap) throws Exception {
        FileResource file;
        String camelComponentName = ConfigureEditEndpointPropertiesStep.optionalAttributeValue(attributeMap, "componentName");
        String endpointInstanceName = ConfigureEditEndpointPropertiesStep.optionalAttributeValue(attributeMap, "instanceName");
        String endpointUrl = ConfigureEditEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "endpointUri");
        String xml = ConfigureEditEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "xml");
        String lineNumber = ConfigureEditEndpointPropertiesStep.mandatoryAttributeValue(attributeMap, "lineNumber");
        Project project = this.getSelectedProject((UIContextProvider)context);
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        Dependency core = CamelProjectHelper.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        CamelComponentDetails details = new CamelComponentDetails();
        Result result = CamelCommandsHelper.loadCamelComponentDetails(camelComponentName, details);
        if (result != null) {
            return result;
        }
        result = CamelCommandsHelper.ensureCamelArtifactIdAdded(project, details, this.dependencyInstaller);
        if (result != null) {
            return result;
        }
        HashMap<String, String> options = new HashMap<String, String>();
        for (InputComponent input : this.inputs) {
            String value;
            String key = input.getName();
            if (input.hasValue()) {
                boolean matchDefault;
                value = input.getValue().toString();
                if (value == null || (matchDefault = CamelCatalogHelper.isDefaultValue(camelComponentName, key, value))) continue;
                options.put(key, value);
                continue;
            }
            if (!input.isRequired() || !input.hasDefaultValue() || (value = input.getValue().toString()) == null) continue;
            options.put(key, value);
        }
        DefaultCamelCatalog catalog = new DefaultCamelCatalog();
        String uri = catalog.asEndpointUri(camelComponentName, options);
        if (uri == null) {
            return Results.fail((String)"Cannot create endpoint uri");
        }
        uri = org.apache.camel.util.StringHelper.xmlEncode((String)uri);
        FileResource fileResource = file = facet != null ? facet.getResource(xml) : null;
        if (file == null || !file.exists()) {
            FileResource fileResource2 = file = webFacet != null ? webFacet.getWebResource(xml) : null;
        }
        if (file == null || !file.exists()) {
            return Results.fail((String)("Cannot find XML file " + xml));
        }
        List<String> lines = LineNumberHelper.readLines(file.getResourceInputStream());
        int idx = lineNumber != null ? Integer.valueOf(lineNumber) - 1 : 0;
        String line = lines.get(idx);
        line = StringHelper.replaceAll(line, endpointUrl, uri);
        lines.set(idx, line);
        String content = LineNumberHelper.linesToString(lines);
        file.setContents(content);
        return Results.success((String)("Update endpoint uri: " + uri + " in XML file " + xml));
    }

    public static String mandatoryAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        throw new IllegalArgumentException("The attribute value '" + name + "' did not get passed on from the previous wizard page");
    }

    public static String optionalAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        return null;
    }
}

