/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.dto.DataFormatDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;

public class CamelDataFormatsCompleter
implements UICompleter<DataFormatDto> {
    private final Project project;
    private final CamelCatalog camelCatalog;
    private final Dependency core;

    public CamelDataFormatsCompleter(Project project, CamelCatalog camelCatalog) {
        this.project = project;
        this.camelCatalog = camelCatalog;
        this.core = CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    public Iterable<DataFormatDto> getCompletionProposals(UIContext context, InputComponent input, String value) {
        if (this.core == null) {
            return null;
        }
        ArrayList<DataFormatDto> answer = new ArrayList<DataFormatDto>();
        List names = this.camelCatalog.findDataFormatNames();
        ArrayList<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (value != null && !name.startsWith(value)) continue;
            filtered.add(name);
        }
        for (String name : filtered) {
            String json = this.camelCatalog.dataFormatJSonSchema(name);
            String artifactId = CamelDataFormatsCompleter.findArtifactId(json);
            boolean already = false;
            if (artifactId != null) {
                already = CamelProjectHelper.hasDependency((Project)this.project, (String)"org.apache.camel", (String)artifactId);
            }
            if (already) continue;
            DataFormatDto dto = CamelCatalogHelper.createDataFormatDto(this.camelCatalog, json);
            answer.add(dto);
        }
        return answer;
    }

    public Iterable<DataFormatDto> getValueChoices() {
        if (this.core == null) {
            return null;
        }
        List names = this.camelCatalog.findDataFormatNames();
        Set artifacts = CamelProjectHelper.findCamelArtifacts((Project)this.project);
        for (Dependency dep : artifacts) {
            Set<String> languages = CamelCatalogHelper.dataFormatsFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
            names.removeAll(languages);
        }
        ArrayList<DataFormatDto> answer = new ArrayList<DataFormatDto>();
        for (String name : names) {
            DataFormatDto dto = CamelCatalogHelper.createDataFormatDto(this.camelCatalog, name);
            answer.add(dto);
        }
        return answer;
    }

    private static String findArtifactId(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"dataformat", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }
}

