/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import io.fabric8.forge.camel.commands.project.helper.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.helper.VersionHelper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.model.Model;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.maven.plugins.ConfigurationElement;
import org.jboss.forge.addon.maven.plugins.ConfigurationElementBuilder;
import org.jboss.forge.addon.maven.plugins.MavenPlugin;
import org.jboss.forge.addon.maven.plugins.MavenPluginBuilder;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.maven.projects.MavenPluginFacet;
import org.jboss.forge.addon.projects.Project;

public class DockerSetupHelper {
    private static String dockerFromImagePrefix = "docker.io/";
    private static String[] jarImages = new String[]{"fabric8/java"};
    private static String[] bundleImages = new String[]{"fabric8/karaf-2.4"};
    private static String[] warImages = new String[]{"fabric8/tomcat-8.0", "jboss/wildfly"};

    public static void setupDocker(Project project, String fromImage, String main) {
        boolean jar;
        MavenPluginBuilder plugin = MavenPluginBuilder.create().setCoordinate(DockerSetupHelper.createCoordinate("org.jolokia", "docker-maven-plugin", VersionHelper.dockerVersion()));
        ConfigurationElementBuilder cfgName = ConfigurationElementBuilder.create().setName("name").setText("${docker.image}");
        ConfigurationElementBuilder cfgFrom = ConfigurationElementBuilder.create().setName("from").setText("${docker.from}");
        ConfigurationElementBuilder cfgDescriptorRef = ConfigurationElementBuilder.create().setName("descriptorRef").setText("${docker.assemblyDescriptorRef}");
        ConfigurationElementBuilder cfgAssembly = ConfigurationElementBuilder.create().setName("assembly");
        cfgAssembly.getChildren().add(cfgDescriptorRef);
        ConfigurationElementBuilder cfgBuild = ConfigurationElementBuilder.create().setName("build");
        cfgBuild.getChildren().add(cfgFrom);
        cfgBuild.getChildren().add(cfgAssembly);
        LinkedHashMap<String, String> envs = new LinkedHashMap<String, String>();
        boolean springBoot = DockerSetupHelper.hasSpringBootMavenPlugin(project);
        String packaging = DockerSetupHelper.getProjectPackaging(project);
        boolean war = packaging != null && packaging.equals("war");
        boolean bundle = packaging != null && packaging.equals("bundle");
        boolean bl = jar = packaging != null && packaging.equals("jar");
        if (springBoot) {
            envs.put("JAR", "${project.artifactId}-${project.version}.war");
            envs.put("JAVA_OPTIONS", "-Djava.security.egd=/dev/./urandom");
        } else if (war) {
            envs.put("CATALINA_OPTS", "-javaagent:/opt/tomcat/jolokia-agent.jar=host=0.0.0.0,port=8778");
        } else if (jar && main != null) {
            envs.put("MAIN", main);
        }
        if (!envs.isEmpty()) {
            ConfigurationElementBuilder cfgEnv = ConfigurationElementBuilder.create().setName("env");
            cfgBuild.getChildren().add(cfgEnv);
            for (Map.Entry env : envs.entrySet()) {
                ConfigurationElementBuilder cfg = ConfigurationElementBuilder.create().setName((String)env.getKey()).setText((String)env.getValue());
                cfgEnv.getChildren().add(cfg);
            }
        }
        if (bundle) {
            ConfigurationElementBuilder cfgCommand = ConfigurationElementBuilder.create().setName("command").setText("/usr/bin/deploy-and-start");
            cfgBuild.getChildren().add(cfgCommand);
        }
        ConfigurationElementBuilder cfgImage = ConfigurationElementBuilder.create().setName("image");
        cfgImage.getChildren().add(cfgName);
        cfgImage.getChildren().add(cfgBuild);
        ConfigurationElementBuilder cfgImages = ConfigurationElementBuilder.create().setName("images");
        cfgImages.getChildren().add(cfgImage);
        DockerSetupHelper.setupDockerProperties(project, fromImage);
        MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
        plugin.createConfiguration().addConfigurationElement((ConfigurationElement)cfgImages);
        pluginFacet.addPlugin((MavenPlugin)plugin);
    }

    public static void setupDockerProperties(Project project, String fromImage) {
        String packaging = DockerSetupHelper.getProjectPackaging(project);
        boolean springBoot = DockerSetupHelper.hasSpringBootMavenPlugin(project);
        boolean war = packaging != null && packaging.equals("war");
        boolean bundle = packaging != null && packaging.equals("bundle");
        boolean jar = packaging != null && packaging.equals("jar");
        MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
        Model pom = maven.getModel();
        Properties properties = pom.getProperties();
        properties.put("docker.registryPrefix", "${env.DOCKER_REGISTRY}/");
        properties.put("docker.from", dockerFromImagePrefix + fromImage);
        properties.put("docker.image", "${docker.registryPrefix}fabric8/${project.artifactId}:${project.version}");
        properties.put("docker.port.container.jolokia", "8778");
        if (springBoot) {
            properties.put("docker.assemblyDescriptorRef", "artifact");
            properties.put("docker.port.container.http", "8080");
        } else if (war) {
            properties.put("docker.assemblyDescriptorRef", "rootWar");
            properties.put("docker.port.container.http", "8080");
        } else if (bundle) {
            properties.put("docker.assemblyDescriptorRef", "artifact-with-dependencies");
            properties.put("docker.port.container.http", "8181");
        } else {
            properties.put("docker.assemblyDescriptorRef", "artifact-with-dependencies");
        }
        maven.setModel(pom);
    }

    public static boolean hasSpringBootMavenPlugin(Project project) {
        if (project != null) {
            MavenPluginFacet pluginFacet = (MavenPluginFacet)project.getFacet(MavenPluginFacet.class);
            CoordinateBuilder coor = CoordinateBuilder.create((String)"org.springframework.boot:spring-boot-maven-plugin");
            return pluginFacet.hasPlugin((Coordinate)coor);
        }
        return false;
    }

    public static String defaultDockerImage(Project project) {
        String packaging = DockerSetupHelper.getProjectPackaging(project);
        if ("jar".equals(packaging)) {
            return jarImages[0];
        }
        if ("bundle".equals(packaging)) {
            return bundleImages[0];
        }
        if ("war".equals(packaging)) {
            return null;
        }
        return null;
    }

    private static String getProjectPackaging(Project project) {
        if (project != null) {
            MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
            return maven.getModel().getPackaging();
        }
        return null;
    }

    public static boolean isJarImage(String fromImage) {
        for (String jar : jarImages) {
            if (!jar.equals(fromImage)) continue;
            return true;
        }
        return false;
    }

    private static Coordinate createCoordinate(String groupId, String artifactId, String version) {
        CoordinateBuilder builder = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        if (version != null) {
            builder = builder.setVersion(version);
        }
        return builder;
    }

    public static String defaultMainClass(Project project) {
        if (CamelProjectHelper.findCamelCDIDependency(project) != null) {
            return "org.apache.camel.cdi.Main";
        }
        if (CamelProjectHelper.findCamelSpringDependency(project) != null) {
            return "org.apache.camel.spring.Main";
        }
        if (CamelProjectHelper.findCamelBlueprintDependency(project) != null) {
            return "org.apache.camel.test.blueprint.Main";
        }
        return null;
    }
}

