/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.CamelComponentDetails;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.util.Strings;

public class ConfigureComponentPropertiesStep
extends AbstractCamelProjectCommand
implements UIWizardStep {
    private final DependencyInstaller dependencyInstaller;
    private final CamelCatalog camelCatalog;
    private final String componentName;
    private final String group;
    private final List<InputComponent> allInputs;
    private final List<InputComponent> inputs;
    private final boolean last;
    private final int index;
    private final int total;

    public ConfigureComponentPropertiesStep(ProjectFactory projectFactory, DependencyInstaller dependencyInstaller, CamelCatalog camelCatalog, String componentName, String group, List<InputComponent> allInputs, List<InputComponent> inputs, boolean last, int index, int total) {
        this.projectFactory = projectFactory;
        this.dependencyInstaller = dependencyInstaller;
        this.camelCatalog = camelCatalog;
        this.componentName = componentName;
        this.group = group;
        this.allInputs = allInputs;
        this.inputs = inputs;
        this.last = last;
        this.index = index + 1;
        this.total = total;
    }

    public String getGroup() {
        return this.group;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTotal() {
        return this.total;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureComponentPropertiesStep.class).name("Camel: Component options").category(Categories.create((String[])new String[]{CATEGORY})).description(String.format("Configure %s options (%s of %s)", this.group, this.index, this.total));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        if (this.inputs != null) {
            for (InputComponent input : this.inputs) {
                builder.add(input);
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        if (this.last) {
            return this.doExecute(context);
        }
        return null;
    }

    private Result doExecute(UIExecutionContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        try {
            String camelComponentName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "componentName");
            String componentInstanceName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "instanceName");
            String generatePackageName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "targetPackage");
            String generateClassName = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "className");
            String kind = ConfigureComponentPropertiesStep.mandatoryAttributeValue(attributeMap, "kind");
            Project project = this.getSelectedProject((UIContextProvider)context);
            JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
            Dependency core = CamelProjectHelper.findCamelCoreDependency((Project)project);
            if (core == null) {
                return Results.fail((String)"The project does not include camel-core");
            }
            CamelComponentDetails details = new CamelComponentDetails();
            Result result = CamelCommandsHelper.loadCamelComponentDetails(this.camelCatalog, camelComponentName, details);
            if (result != null) {
                return result;
            }
            result = CamelCommandsHelper.ensureCamelArtifactIdAdded(project, details, this.dependencyInstaller);
            if (result != null) {
                return result;
            }
            String fqn = generatePackageName != null ? generatePackageName + "." + generateClassName : generateClassName;
            JavaResource existing = facet.getJavaResource(fqn);
            if (existing != null && existing.exists()) {
                return Results.fail((String)("A class with name " + fqn + " already exists"));
            }
            JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
            javaClass.setName(generateClassName);
            if (generatePackageName != null) {
                javaClass.setPackage(generatePackageName);
            }
            LinkedHashMap<Object, Object> options = new LinkedHashMap<Object, Object>();
            for (InputComponent input : this.allInputs) {
                Object object;
                String key = input.getName();
                if (input.hasValue()) {
                    Object object2 = input.getValue();
                    String text = input.getValue().toString();
                    if (text == null) continue;
                    boolean matchDefault = CamelCatalogHelper.isDefaultValueComponent(this.camelCatalog, camelComponentName, key, text);
                    if ("none".equals(text)) {
                        boolean nonePlaceholder = CamelCatalogHelper.isNonePlaceholderEnumValueComponent(this.camelCatalog, camelComponentName, key);
                        if (matchDefault || nonePlaceholder) continue;
                        options.put(key, object2);
                        continue;
                    }
                    if (matchDefault) continue;
                    options.put(key, object2);
                    continue;
                }
                if (!input.isRequired() || !input.hasDefaultValue() || (object = input.getValue()) == null) continue;
                options.put(key, object);
            }
            HashSet<String> extraJavaImports = new HashSet<String>();
            StringBuilder buffer = new StringBuilder();
            for (Map.Entry entry : options.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                String valueExpression = null;
                String enumJavaType = CamelCatalogHelper.getEnumJavaTypeComponent(this.camelCatalog, camelComponentName, key);
                if (enumJavaType != null) {
                    extraJavaImports.add(enumJavaType);
                    String simpleName = enumJavaType;
                    int idx = simpleName.lastIndexOf(".");
                    if (idx != -1) {
                        simpleName = simpleName.substring(idx + 1);
                    }
                    valueExpression = simpleName + "." + value;
                } else if (value instanceof String) {
                    String text = value.toString();
                    if (!Strings.isBlank((String)text)) {
                        valueExpression = "\"" + text + "\"";
                    }
                } else {
                    valueExpression = value.toString();
                }
                if (valueExpression == null) continue;
                buffer.append("\n");
                buffer.append("component.set");
                buffer.append(Strings.capitalize((String)key));
                buffer.append("(");
                buffer.append(valueExpression);
                buffer.append(");");
            }
            String configurationCode = buffer.toString();
            if (kind.equals("cdi")) {
                CamelCommandsHelper.createCdiComponentProducerClass(javaClass, details, camelComponentName, componentInstanceName, configurationCode, extraJavaImports);
            } else if (kind.equals("spring")) {
                CamelCommandsHelper.createSpringComponentFactoryClass(javaClass, details, camelComponentName, componentInstanceName, configurationCode, extraJavaImports);
            } else {
                CamelCommandsHelper.createJavaComponentFactoryClass(javaClass, details, camelComponentName, componentInstanceName, configurationCode, extraJavaImports);
            }
            facet.saveJavaSource((JavaSource)javaClass);
            return Results.success((String)("Created new class " + generateClassName));
        }
        catch (Exception e) {
            return Results.fail((String)e.getMessage());
        }
    }

    public static String mandatoryAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        throw new IllegalArgumentException("The attribute value '" + name + "' did not get passed on from the previous wizard page");
    }
}

