/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.addon.utils.UIHelper;
import io.fabric8.forge.camel.commands.project.completer.CamelComponentsCompleter;
import io.fabric8.forge.camel.commands.project.completer.CamelComponentsLabelCompleter;
import io.fabric8.forge.camel.commands.project.completer.CamelEipsCompleter;
import io.fabric8.forge.camel.commands.project.completer.CamelEipsLabelCompleter;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.dto.EipDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.model.CamelComponentDetails;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.shell.ui.ShellContext;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;
import org.jboss.forge.roaster.model.util.Strings;

public final class CamelCommandsHelper {
    public static Iterable<String> createComponentLabelValues(Project project, CamelCatalog camelCatalog) {
        return new CamelComponentsLabelCompleter(project, camelCatalog).getValueChoices();
    }

    public static Iterable<String> createEipLabelValues(Project project, CamelCatalog camelCatalog) {
        return new CamelEipsLabelCompleter(project, camelCatalog).getValueChoices();
    }

    public static Callable<Iterable<ComponentDto>> createAllComponentDtoValues(final Project project, final CamelCatalog camelCatalog, final UISelectOne<String> componentCategoryFilter, final boolean excludeComponentsOnClasspath) {
        return new Callable<Iterable<ComponentDto>>(){

            @Override
            public Iterable<ComponentDto> call() throws Exception {
                String label = (String)componentCategoryFilter.getValue();
                return new CamelComponentsCompleter(project, camelCatalog, null, excludeComponentsOnClasspath, true, false, false).getValueChoices(label);
            }
        };
    }

    public static Callable<Iterable<ComponentDto>> createComponentDtoValues(final Project project, final CamelCatalog camelCatalog, final UISelectOne<String> componentCategoryFilter, final boolean excludeComponentsOnClasspath) {
        return new Callable<Iterable<ComponentDto>>(){

            @Override
            public Iterable<ComponentDto> call() throws Exception {
                String label = componentCategoryFilter != null ? (String)componentCategoryFilter.getValue() : null;
                return new CamelComponentsCompleter(project, camelCatalog, null, excludeComponentsOnClasspath, false, false, false).getValueChoices(label);
            }
        };
    }

    public static Callable<Iterable<ComponentDto>> createComponentDtoValues(final Project project, final CamelCatalog camelCatalog, final UISelectOne<String> componentCategoryFilter, final boolean excludeComponentsOnClasspath, final boolean consumerOnly, final boolean producerOnly) {
        return new Callable<Iterable<ComponentDto>>(){

            @Override
            public Iterable<ComponentDto> call() throws Exception {
                String label = componentCategoryFilter != null ? (String)componentCategoryFilter.getValue() : null;
                return new CamelComponentsCompleter(project, camelCatalog, null, excludeComponentsOnClasspath, false, consumerOnly, producerOnly).getValueChoices(label);
            }
        };
    }

    public static Callable<Iterable<EipDto>> createAllEipDtoValues(final Project project, final CamelCatalog camelCatalog, final UISelectOne<String> eipCategoryFilter) {
        return new Callable<Iterable<EipDto>>(){

            @Override
            public Iterable<EipDto> call() throws Exception {
                String label = eipCategoryFilter != null ? (String)eipCategoryFilter.getValue() : null;
                return new CamelEipsCompleter(project, camelCatalog).getValueChoices(label);
            }
        };
    }

    public static Result loadCamelComponentDetails(CamelCatalog camelCatalog, String camelComponentName, CamelComponentDetails details) {
        String json = camelCatalog.componentJSonSchema(camelComponentName);
        if (json == null) {
            return Results.fail((String)("Could not find catalog entry for component name: " + camelComponentName));
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"component", (String)json, (boolean)false);
        for (Map row : data) {
            String version;
            String artifactId;
            String groupId;
            String javaType = (String)row.get("javaType");
            if (!Strings.isNullOrEmpty((String)javaType)) {
                details.setComponentClassQName(javaType);
            }
            if (!Strings.isNullOrEmpty((String)(groupId = (String)row.get("groupId")))) {
                details.setGroupId(groupId);
            }
            if (!Strings.isNullOrEmpty((String)(artifactId = (String)row.get("artifactId")))) {
                details.setArtifactId(artifactId);
            }
            if (Strings.isNullOrEmpty((String)(version = (String)row.get("version")))) continue;
            details.setVersion(version);
        }
        if (Strings.isNullOrEmpty((String)details.getComponentClassQName())) {
            return Results.fail((String)("Could not find fully qualified class name in catalog for component name: " + camelComponentName));
        }
        return null;
    }

    public static Result ensureCamelArtifactIdAdded(Project project, CamelComponentDetails details, DependencyInstaller dependencyInstaller) {
        String groupId = details.getGroupId();
        String artifactId = details.getArtifactId();
        Dependency core = CamelProjectHelper.findCamelCoreDependency((Project)project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        String version = "org.apache.camel".equals(groupId) ? core.getCoordinate().getVersion() : details.getVersion();
        DependencyBuilder component = DependencyBuilder.create().setGroupId(groupId).setArtifactId(artifactId).setVersion(version);
        dependencyInstaller.install(project, (Dependency)component);
        return null;
    }

    public static boolean isCdiProject(Project project) {
        return CamelProjectHelper.findCamelCDIDependency((Project)project) != null;
    }

    public static boolean isSpringProject(Project project) {
        return CamelProjectHelper.findCamelSpringDependency((Project)project) != null;
    }

    public static boolean isBlueprintProject(Project project) {
        return CamelProjectHelper.findCamelBlueprintDependency((Project)project) != null;
    }

    public static void createCdiComponentProducerClass(JavaClassSource javaClass, CamelComponentDetails details, String camelComponentName, String componentInstanceName, String configurationCode) {
        javaClass.addImport("javax.enterprise.inject.Produces");
        javaClass.addImport("javax.inject.Singleton");
        javaClass.addImport("javax.inject.Named");
        javaClass.addImport(details.getComponentClassQName());
        String componentClassName = details.getComponentClassName();
        String methodName = "create" + Strings.capitalize((String)componentInstanceName) + "Component";
        String body = componentClassName + " component = new " + componentClassName + "();" + configurationCode + "\nreturn component;";
        MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnType(componentClassName).setName(methodName)).setBody(body).addThrows(Exception.class);
        method.addAnnotation("Named").setStringValue(camelComponentName);
        method.addAnnotation("Produces");
        method.addAnnotation("Singleton");
    }

    public static void createSpringComponentFactoryClass(JavaClassSource javaClass, CamelComponentDetails details, String camelComponentName, String componentInstanceName, String configurationCode) {
        javaClass.addAnnotation("Component");
        javaClass.addImport("org.springframework.beans.factory.config.BeanDefinition");
        javaClass.addImport("org.springframework.beans.factory.annotation.Qualifier");
        javaClass.addImport("org.springframework.context.annotation.Bean");
        javaClass.addImport("org.springframework.context.annotation.Scope");
        javaClass.addImport("org.springframework.stereotype.Component");
        javaClass.addImport(details.getComponentClassQName());
        String componentClassName = details.getComponentClassName();
        String methodName = "create" + Strings.capitalize((String)componentInstanceName) + "Component";
        String body = componentClassName + " component = new " + componentClassName + "();" + configurationCode + "\nreturn component;";
        MethodSource method = ((MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnType(componentClassName).setName(methodName)).setBody(body).addThrows(Exception.class);
        method.addAnnotation("Qualifier").setStringValue(camelComponentName);
        method.addAnnotation("Bean");
        method.addAnnotation("Scope").setLiteralValue("BeanDefinition.SCOPE_SINGLETON");
    }

    public static Class<Object> loadValidInputTypes(String javaType, String type) {
        int idx = javaType.indexOf(60);
        if (idx > 0) {
            javaType = javaType.substring(0, idx);
        }
        try {
            Class clazz;
            block10: {
                clazz = CamelCommandsHelper.getPrimitiveWrapperClassType(type);
                if (clazz == null) {
                    clazz = CamelCommandsHelper.loadPrimitiveWrapperType(javaType);
                }
                if (clazz == null) {
                    clazz = CamelCommandsHelper.loadStringSupportedType(javaType);
                }
                if (clazz == null) {
                    try {
                        clazz = Class.forName(javaType);
                    }
                    catch (Throwable e) {
                        if (!"object".equals(type)) break block10;
                        clazz = CamelCommandsHelper.loadPrimitiveWrapperType("java.lang.String");
                    }
                }
            }
            if (clazz != null && (clazz.equals(String.class) || clazz.equals(Date.class) || clazz.equals(Boolean.class) || clazz.isPrimitive() || Number.class.isAssignableFrom(clazz))) {
                return clazz;
            }
            if ("object".equals(type)) {
                clazz = CamelCommandsHelper.loadPrimitiveWrapperType("java.lang.String");
                return clazz;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static Class loadStringSupportedType(String javaType) {
        if ("java.io.File".equals(javaType)) {
            return String.class;
        }
        if ("java.net.URL".equals(javaType)) {
            return String.class;
        }
        if ("java.net.URI".equals(javaType)) {
            return String.class;
        }
        return null;
    }

    public static Class getPrimitiveWrapperClassType(String name) {
        if ("string".equals(name)) {
            return String.class;
        }
        if ("boolean".equals(name)) {
            return Boolean.class;
        }
        if ("integer".equals(name)) {
            return Integer.class;
        }
        if ("number".equals(name)) {
            return Float.class;
        }
        return null;
    }

    private static Class loadPrimitiveWrapperType(String name) {
        if ("java.lang.byte[]".equals(name) || "byte[]".equals(name)) {
            return Byte[].class;
        }
        if ("java.lang.Byte[]".equals(name) || "Byte[]".equals(name)) {
            return Byte[].class;
        }
        if ("java.lang.Object[]".equals(name) || "Object[]".equals(name)) {
            return Object[].class;
        }
        if ("java.lang.String[]".equals(name) || "String[]".equals(name)) {
            return String[].class;
        }
        if ("java.lang.String".equals(name) || "String".equals(name)) {
            return String.class;
        }
        if ("java.lang.Boolean".equals(name) || "Boolean".equals(name)) {
            return Boolean.class;
        }
        if ("boolean".equals(name)) {
            return Boolean.class;
        }
        if ("java.lang.Integer".equals(name) || "Integer".equals(name)) {
            return Integer.class;
        }
        if ("int".equals(name)) {
            return Integer.class;
        }
        if ("java.lang.Long".equals(name) || "Long".equals(name)) {
            return Long.class;
        }
        if ("long".equals(name)) {
            return Long.class;
        }
        if ("java.lang.Short".equals(name) || "Short".equals(name)) {
            return Short.class;
        }
        if ("short".equals(name)) {
            return Short.class;
        }
        if ("java.lang.Byte".equals(name) || "Byte".equals(name)) {
            return Byte.class;
        }
        if ("byte".equals(name)) {
            return Byte.class;
        }
        if ("java.lang.Float".equals(name) || "Float".equals(name)) {
            return Float.class;
        }
        if ("float".equals(name)) {
            return Float.class;
        }
        if ("java.lang.Double".equals(name) || "Double".equals(name)) {
            return Double.class;
        }
        if ("double".equals(name)) {
            return Double.class;
        }
        if ("java.lang.Character".equals(name) || "Character".equals(name)) {
            return Character.class;
        }
        if ("char".equals(name)) {
            return Character.class;
        }
        return null;
    }

    public static List<InputOptionByGroup> createUIInputsForCamelComponent(String camelComponentName, String uri, int maxOptionsPerPage, boolean consumerOnly, boolean producerOnly, CamelCatalog camelCatalog, InputComponentFactory componentFactory, ConverterFactory converterFactory, UIContext ui) throws Exception {
        Map currentValues;
        String json;
        ArrayList<InputOptionByGroup> answer = new ArrayList<InputOptionByGroup>();
        if (camelComponentName == null && uri != null) {
            camelComponentName = CamelCatalogHelper.endpointComponentName(uri);
        }
        if ((json = camelCatalog.componentJSonSchema(camelComponentName)) == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        boolean componentConsumerOnly = CamelCatalogHelper.isComponentConsumerOnly(camelCatalog, camelComponentName);
        boolean componentProducerOnly = CamelCatalogHelper.isComponentProducerOnly(camelCatalog, camelComponentName);
        if (componentConsumerOnly || componentProducerOnly) {
            consumerOnly = false;
            producerOnly = false;
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        Map map = currentValues = uri != null ? camelCatalog.endpointProperties(uri) : Collections.EMPTY_MAP;
        if (data != null) {
            boolean promptInInteractiveMode = false;
            if (ui instanceof ShellContext) {
                boolean params = ((ShellContext)ui).getCommandLine().hasParameters();
                promptInInteractiveMode = !params;
            }
            ArrayList<Object> inputs = new ArrayList<InputComponent>();
            InputOptionByGroup current = new InputOptionByGroup();
            current.setGroup(null);
            current.setInputs(inputs);
            HashSet<String> namesAdded = new HashSet<String>();
            for (Map propertyMap : data) {
                Class<Object> inputClazz;
                String name = (String)propertyMap.get("name");
                String kind = (String)propertyMap.get("kind");
                String group = (String)propertyMap.get("group");
                String label = (String)propertyMap.get("label");
                String type = (String)propertyMap.get("type");
                String javaType = (String)propertyMap.get("javaType");
                String deprecated = (String)propertyMap.get("deprecated");
                String required = (String)propertyMap.get("required");
                String currentValue = (String)currentValues.get(name);
                String defaultValue = (String)propertyMap.get("defaultValue");
                String description = (String)propertyMap.get("description");
                String enums = (String)propertyMap.get("enum");
                String prefix = (String)propertyMap.get("prefix");
                String multiValue = (String)propertyMap.get("multiValue");
                if (current.getGroup() == null) {
                    current.setGroup(group);
                }
                if (group != null && !group.equals(current.getGroup())) {
                    if (!current.getInputs().isEmpty()) {
                        answer.add(current);
                    }
                    inputs = new ArrayList();
                    current = new InputOptionByGroup();
                    current.setGroup(group);
                    current.setInputs(inputs);
                }
                if (consumerOnly && label != null && !label.contains("consumer") || producerOnly && label != null && !label.contains("producer") || Strings.isNullOrEmpty((String)name) || (inputClazz = CamelCommandsHelper.loadValidInputTypes(javaType, type)) == null || !namesAdded.add(name)) continue;
                if (enums != null && (required == null || "false".equals(required)) && (defaultValue == null || defaultValue.isEmpty())) {
                    defaultValue = "none";
                    if (!enums.startsWith("none,")) {
                        enums = "none," + enums;
                    }
                }
                boolean multi = "true".equals(multiValue);
                InputComponent input = UIHelper.createUIInput((UIProvider)ui.getProvider(), (InputComponentFactory)componentFactory, (ConverterFactory)converterFactory, (String)name, inputClazz, (String)required, (String)currentValue, (String)defaultValue, (String)enums, (String)description, (boolean)promptInInteractiveMode, (boolean)multi, (String)prefix);
                if (input == null) continue;
                inputs.add(input);
                if (inputs.size() != maxOptionsPerPage) continue;
                if (!current.getInputs().isEmpty()) {
                    answer.add(current);
                }
                inputs = new ArrayList();
                current = new InputOptionByGroup();
                current.setGroup(group);
                current.setInputs(inputs);
            }
            if (!inputs.isEmpty()) {
                answer.add(current);
            }
        }
        for (InputOptionByGroup group : answer) {
            if (group.getGroup() != null) continue;
            group.setGroup("common");
        }
        return answer;
    }

    public static List<InputOptionByGroup> createUIInputsForCamelEIP(String eip, int maxOptionsPerPage, Map<String, String> currentValues, CamelCatalog camelCatalog, InputComponentFactory componentFactory, ConverterFactory converterFactory, UIContext ui) throws Exception {
        ArrayList<InputOptionByGroup> answer = new ArrayList<InputOptionByGroup>();
        String json = camelCatalog.modelJSonSchema(eip);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for model name: " + eip);
        }
        List data = JSonSchemaHelper.parseJsonSchema((String)"properties", (String)json, (boolean)true);
        if (data != null) {
            boolean promptInInteractiveMode = false;
            if (ui instanceof ShellContext) {
                boolean params = ((ShellContext)ui).getCommandLine().hasParameters();
                promptInInteractiveMode = !params;
            }
            ArrayList<Object> inputs = new ArrayList<InputComponent>();
            InputOptionByGroup current = new InputOptionByGroup();
            current.setGroup(null);
            current.setInputs(inputs);
            HashSet<String> namesAdded = new HashSet<String>();
            for (Map propertyMap : data) {
                String enumsOrOneOfs;
                Class<Object> inputClazz;
                String name = (String)propertyMap.get("name");
                String kind = (String)propertyMap.get("kind");
                String group = (String)propertyMap.get("group");
                String label = (String)propertyMap.get("label");
                String type = (String)propertyMap.get("type");
                String javaType = (String)propertyMap.get("javaType");
                String deprecated = (String)propertyMap.get("deprecated");
                String required = (String)propertyMap.get("required");
                String currentValue = currentValues != null ? currentValues.get(name) : null;
                String defaultValue = (String)propertyMap.get("defaultValue");
                String description = (String)propertyMap.get("description");
                String enums = (String)propertyMap.get("enum");
                String oneOf = (String)propertyMap.get("oneOf");
                if ("outputs".equals(name)) continue;
                if (current.getGroup() == null) {
                    current.setGroup(group);
                }
                if (group != null && !group.equals(current.getGroup())) {
                    if (!current.getInputs().isEmpty()) {
                        answer.add(current);
                    }
                    inputs = new ArrayList();
                    current = new InputOptionByGroup();
                    current.setGroup(group);
                    current.setInputs(inputs);
                }
                if (Strings.isNullOrEmpty((String)name) || (inputClazz = CamelCommandsHelper.loadValidInputTypes(javaType, type)) == null || !namesAdded.add(name)) continue;
                if (enums != null && (required == null || "false".equals(required)) && (defaultValue == null || defaultValue.isEmpty())) {
                    defaultValue = "none";
                    if (!enums.startsWith("none,")) {
                        enums = "none," + enums;
                    }
                }
                if (oneOf != null && (required == null || "false".equals(required)) && (defaultValue == null || defaultValue.isEmpty())) {
                    defaultValue = "none";
                    if (!oneOf.startsWith("none,")) {
                        oneOf = "none," + oneOf;
                    }
                }
                String string = enumsOrOneOfs = enums != null ? enums : oneOf;
                InputComponent input = UIHelper.createUIInput((UIProvider)ui.getProvider(), (InputComponentFactory)componentFactory, (ConverterFactory)converterFactory, (String)name, inputClazz, (String)required, (String)currentValue, (String)defaultValue, (String)enumsOrOneOfs, (String)description, (boolean)promptInInteractiveMode, (boolean)false, null);
                if (input == null) continue;
                inputs.add(input);
                if ("expression".equals(kind)) {
                    currentValue = currentValues != null ? currentValues.get(name + "_value") : null;
                    InputComponent input2 = UIHelper.createUIInput((UIProvider)ui.getProvider(), (InputComponentFactory)componentFactory, (ConverterFactory)converterFactory, (String)(name + "_value"), String.class, (String)required, (String)currentValue, null, null, (String)description, (boolean)promptInInteractiveMode, (boolean)false, null);
                    if (input2 != null) {
                        inputs.add(input2);
                    }
                }
                if (inputs.size() != maxOptionsPerPage) continue;
                if (!current.getInputs().isEmpty()) {
                    answer.add(current);
                }
                inputs = new ArrayList();
                current = new InputOptionByGroup();
                current.setGroup(group);
                current.setInputs(inputs);
            }
            if (!inputs.isEmpty()) {
                answer.add(current);
            }
        }
        for (InputOptionByGroup group : answer) {
            if (group.getGroup() != null) continue;
            group.setGroup("common");
        }
        return answer;
    }
}

