/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelEditCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final int MAX_OPTIONS = 20;
    @Inject
    @WithAttributes(label="Endpoints", required=true, description="The endpoints from the project")
    private UISelectOne<String> endpoints;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    private RouteBuilderEndpointsCompleter javaCompleter;
    private XmlEndpointsCompleter xmlCompleter;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditCommand.class).name("Camel: Edit").category(Categories.create((String[])new String[]{CATEGORY})).description("Edit Camel endpoint or EIP from the current cursor position");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean answer = super.isEnabled(context);
        if (answer) {
            String currentFile = this.getSelectedFile(context);
            answer = currentFile != null;
        }
        return answer;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        String currentFile = this.getSelectedFile(builder.getUIContext());
        int cursorLineNumber = this.getCurrentCursorLine(builder.getUIContext());
        boolean xmlFile = currentFile.endsWith(".xml");
        if (!xmlFile) {
            this.javaCompleter = this.createRouteBuilderEndpointsCompleter(builder.getUIContext(), currentFile::equals);
            boolean found = false;
            if (cursorLineNumber != -1) {
                for (CamelEndpointDetails detail : this.javaCompleter.getEndpoints()) {
                    if (detail.getLineNumber() == null || Integer.valueOf(detail.getLineNumber()) != cursorLineNumber) continue;
                    this.endpoints.setValue((Object)detail.getEndpointUri());
                    this.endpoints.setRequired(false);
                    found = true;
                    break;
                }
            }
            if (!found && !this.javaCompleter.getEndpoints().isEmpty()) {
                List<String> uris = this.javaCompleter.getEndpointUris();
                uris.add(0, "<select>");
                this.endpoints.setValueChoices(uris);
                builder.add(this.endpoints);
            }
        } else {
            this.xmlCompleter = this.createXmlEndpointsCompleter(builder.getUIContext(), currentFile::equals);
            boolean found = false;
            if (cursorLineNumber != -1) {
                for (CamelEndpointDetails detail : this.xmlCompleter.getEndpoints()) {
                    if (detail.getLineNumber() == null || Integer.valueOf(detail.getLineNumber()) != cursorLineNumber) continue;
                    this.endpoints.setValue((Object)detail.getEndpointUri());
                    this.endpoints.setRequired(false);
                    found = true;
                    break;
                }
            }
            if (!found && !this.xmlCompleter.getEndpoints().isEmpty()) {
                List<String> uris = this.xmlCompleter.getEndpointUris();
                uris.add(0, "<select>");
                this.endpoints.setValueChoices((Iterable)uris);
                builder.add(this.endpoints);
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        String selectedUri = (String)this.endpoints.getValue();
        if ("<select>".equals(selectedUri)) {
            attributeMap.remove("navigationResult");
            return null;
        }
        String previous = (String)attributeMap.get("endpointUri");
        if (previous != null && previous.equals(this.endpoints.getValue()) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        CamelEndpointDetails detail = null;
        if (this.javaCompleter != null) {
            detail = this.javaCompleter.getEndpointDetail(selectedUri);
        } else if (this.xmlCompleter != null) {
            detail = this.xmlCompleter.getEndpointDetail(selectedUri);
        }
        if (detail == null) {
            return null;
        }
        attributeMap.put("componentName", detail.getEndpointComponentName());
        attributeMap.put("instanceName", detail.getEndpointInstance());
        attributeMap.put("endpointUri", detail.getEndpointUri());
        attributeMap.put("lineNumber", detail.getLineNumber());
        attributeMap.put("lineNumberEnd", detail.getLineNumberEnd());
        attributeMap.put("mode", "edit");
        if (this.javaCompleter != null) {
            attributeMap.put("routeBuilder", detail.getFileName());
            attributeMap.put("kind", "java");
        } else {
            attributeMap.put("xml", detail.getFileName());
            attributeMap.put("kind", "xml");
        }
        String camelComponentName = detail.getEndpointComponentName();
        String uri = detail.getEndpointUri();
        String json = this.getCamelCatalog().componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        boolean consumerOnly = detail.isConsumerOnly();
        boolean producerOnly = detail.isProducerOnly();
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, uri, 20, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return null;
    }
}

