/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.context.UIRegion;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelEditCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    private static final int MAX_OPTIONS = 20;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditCommand.class).name("Camel: Edit").category(Categories.create((String[])new String[]{CATEGORY})).description("Edit Camel endpoint or EIP from the current cursor position");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        String currentFile = this.getSelectedFile(builder.getUIContext());
        if (currentFile == null) {
            attributeMap.remove("endpointUri");
        } else {
            Optional region = builder.getUIContext().getSelection().getRegion();
            if (region.isPresent()) {
                int lineNumber = ((UIRegion)region.get()).getStartLine();
                int lineNumberEnd = ((UIRegion)region.get()).getEndLine();
                int pos = ((UIRegion)region.get()).getStartPosition();
                int endPos = ((UIRegion)region.get()).getEndPosition();
                String text = ((UIRegion)region.get()).getText().orElse("");
                String res = ((UIRegion)region.get()).getResource().toString();
                String msg = String.format("line %s(%s)-%s(%s): %s | %s", lineNumber, pos, lineNumberEnd, endPos, text, res);
                boolean found = false;
                RouteBuilderEndpointsCompleter completer = this.createRouteBuilderEndpointsCompleter(builder.getUIContext(), currentFile::equals);
                for (CamelEndpointDetails detail : completer.getEndpoints()) {
                    if (detail.getLineNumber() == null || Integer.valueOf(detail.getLineNumber()) != lineNumber) continue;
                    msg = detail.getEndpointUri();
                    attributeMap.put("componentName", detail.getEndpointComponentName());
                    attributeMap.put("instanceName", detail.getEndpointInstance());
                    attributeMap.put("endpointUri", detail.getEndpointUri());
                    attributeMap.put("lineNumber", detail.getLineNumber());
                    attributeMap.put("lineNumberEnd", detail.getLineNumberEnd());
                    attributeMap.put("consumerOnly", detail.isConsumerOnly());
                    attributeMap.put("producerOnly", detail.isProducerOnly());
                    attributeMap.put("routeBuilder", detail.getFileName());
                    attributeMap.put("mode", "edit");
                    attributeMap.put("kind", "java");
                    found = true;
                    break;
                }
                if (!found) {
                    XmlEndpointsCompleter completer2 = this.createXmlEndpointsCompleter(builder.getUIContext(), currentFile::equals);
                    for (CamelEndpointDetails detail : completer2.getEndpoints()) {
                        if (detail.getLineNumber() == null || Integer.valueOf(detail.getLineNumber()) != lineNumber) continue;
                        msg = detail.getEndpointUri();
                        attributeMap.put("componentName", detail.getEndpointComponentName());
                        attributeMap.put("instanceName", detail.getEndpointInstance());
                        attributeMap.put("endpointUri", detail.getEndpointUri());
                        attributeMap.put("lineNumber", detail.getLineNumber());
                        attributeMap.put("lineNumberEnd", detail.getLineNumberEnd());
                        attributeMap.put("consumerOnly", detail.isConsumerOnly());
                        attributeMap.put("producerOnly", detail.isProducerOnly());
                        attributeMap.put("xml", detail.getFileName());
                        attributeMap.put("mode", "edit");
                        attributeMap.put("kind", "xml");
                        found = true;
                        break;
                    }
                }
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        NavigationResult navigationResult = (NavigationResult)attributeMap.get("navigationResult");
        if (navigationResult != null) {
            return navigationResult;
        }
        String uri = (String)attributeMap.get("endpointUri");
        if (uri == null) {
            return null;
        }
        String camelComponentName = (String)attributeMap.get("componentName");
        String json = this.getCamelCatalog().componentJSonSchema(camelComponentName);
        if (json == null) {
            throw new IllegalArgumentException("Could not find catalog entry for component name: " + camelComponentName);
        }
        boolean consumerOnly = (Boolean)attributeMap.get("consumerOnly");
        boolean producerOnly = (Boolean)attributeMap.get("producerOnly");
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, uri, 20, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        navigationResult = builder.build();
        attributeMap.put("navigationResult", navigationResult);
        return navigationResult;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        String uri = (String)attributeMap.get("endpointUri");
        if (uri == null) {
            return Results.fail((String)"No Camel endpoint found at cursor position");
        }
        return Results.success();
    }
}

