/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelEndpoints;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

@Deprecated
public class CamelAddEndpointDefinitionXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    public static final int MAX_OPTIONS = 20;
    @Inject
    @WithAttributes(label="Filter", required=false, description="To filter components")
    private UISelectOne<String> componentNameFilter;
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of component to use for the endpoint")
    private UISelectOne<ComponentDto> componentName;
    @Inject
    @WithAttributes(label="Endpoint type", required=true, description="Type of endpoint")
    private UISelectOne<String> endpointType;
    @Inject
    @WithAttributes(label="Instance Name", required=true, description="Name of endpoint instance to add")
    private UIInput<String> instanceName;
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddEndpointDefinitionXmlCommand.class).name("Camel: Add Endpoint Definition XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel endpoint to an existing XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(builder.getUIContext());
        String currentFile = this.getSelectedFile(builder.getUIContext());
        String selected = this.configureXml(project, this.xml, currentFile);
        this.componentNameFilter.setValueChoices(CamelCommandsHelper.createComponentLabelValues(project, this.getCamelCatalog()));
        this.componentNameFilter.setDefaultValue((Object)"<all>");
        this.componentName.setValueChoices(CamelCommandsHelper.createComponentDtoValues(project, this.getCamelCatalog(), this.componentNameFilter, false));
        this.componentName.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String text) {
                return CamelCatalogHelper.createComponentDto(CamelAddEndpointDefinitionXmlCommand.this.getCamelCatalog(), text);
            }
        });
        this.componentName.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String name) {
                return CamelCatalogHelper.createComponentDto(CamelAddEndpointDefinitionXmlCommand.this.getCamelCatalog(), name);
            }
        });
        this.componentName.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                ComponentDto component = (ComponentDto)event.getNewValue();
                if (component != null) {
                    String description = component.getDescription();
                    CamelAddEndpointDefinitionXmlCommand.this.componentName.setNote(description != null ? description : "");
                } else {
                    CamelAddEndpointDefinitionXmlCommand.this.componentName.setNote("");
                }
                if (component != null) {
                    boolean consumerOnly = component.isConsumerOnly();
                    boolean producerOnly = component.isProducerOnly();
                    if (consumerOnly) {
                        String[] types = new String[]{"Consumer"};
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setValueChoices(Arrays.asList(types));
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setValue((Object)"Consumer");
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setDefaultValue((Object)"Consumer");
                    } else if (producerOnly) {
                        String[] types = new String[]{"Producer"};
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setValueChoices(Arrays.asList(types));
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setValue((Object)"Producer");
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setDefaultValue((Object)"Producer");
                    } else {
                        String[] types = new String[]{"<any>", "Consumer", "Producer"};
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setValueChoices(Arrays.asList(types));
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setValue((Object)"<any>");
                        CamelAddEndpointDefinitionXmlCommand.this.endpointType.setDefaultValue((Object)"<any>");
                    }
                } else {
                    String[] types = new String[]{"<any>", "Consumer", "Producer"};
                    CamelAddEndpointDefinitionXmlCommand.this.endpointType.setValueChoices(Arrays.asList(types));
                    CamelAddEndpointDefinitionXmlCommand.this.endpointType.setValue((Object)"<any>");
                    CamelAddEndpointDefinitionXmlCommand.this.endpointType.setDefaultValue((Object)"<any>");
                }
            }
        });
        String[] types = new String[]{"<any>", "Consumer", "Producer"};
        this.endpointType.setValueChoices(Arrays.asList(types));
        this.endpointType.setDefaultValue((Object)"<any>");
        XmlEndpointsCompleter endpointCompleter = this.createXmlEndpointsCompleter(project, null);
        this.instanceName.setDefaultValue((Object)CamelEndpoints.createDefaultNewInstanceName(endpointCompleter.getEndpoints()));
        builder.add(this.componentNameFilter).add(this.componentName).add(this.instanceName).add(this.xml).add(this.endpointType);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put("instanceName", this.instanceName.getValue());
        attributeMap.put("xml", this.xml.getValue());
        attributeMap.put("mode", "add");
        attributeMap.put("kind", "xml");
        ComponentDto component = (ComponentDto)this.componentName.getValue();
        String camelComponentName = component.getScheme();
        String previous = (String)attributeMap.get("componentName");
        String previous2 = (String)attributeMap.get("endpointType");
        if (previous != null && previous.equals(camelComponentName) && previous2 != null && previous2.equals(this.endpointType.getValue()) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        attributeMap.put("componentName", camelComponentName);
        attributeMap.put("endpointType", this.endpointType.getValue());
        boolean consumerOnly = false;
        boolean producerOnly = false;
        String type = (String)this.endpointType.getValue();
        if ("Consumer".equals(type)) {
            consumerOnly = true;
        } else if ("Producer".equals(type)) {
            producerOnly = true;
        }
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, null, 20, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            ConfigureEndpointPropertiesStep step = new ConfigureEndpointPropertiesStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages);
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

