/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.CamelDeleteNodeXmlCommand;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import io.fabric8.forge.camel.commands.project.converter.NodeDtoConverter;
import io.fabric8.forge.camel.commands.project.converter.NodeDtoLabelConverter;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtos;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.helper.CollectionHelper;
import io.fabric8.utils.Strings;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.apache.camel.catalog.CamelCatalog;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.convert.ConverterFactory;
import org.jboss.forge.addon.dependencies.Coordinate;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.CoordinateBuilder;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.Projects;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractCamelProjectCommand
extends AbstractProjectCommand {
    public static String CATEGORY = "Camel";
    @Inject
    protected ProjectFactory projectFactory;
    @Inject
    protected ConverterFactory converterFactory;
    @Inject
    private CamelCatalog camelCatalog;

    protected void configureNode(final UIContext context, final Project project, final String first, final UISelectOne<String> xml, UISelectOne<NodeDto> node) {
        node.setValueConverter((Converter)new NodeDtoConverter(this.camelCatalog, project, context, xml));
        node.setItemLabelConverter((Converter)new NodeDtoLabelConverter());
        node.setValueChoices((Callable)new Callable<Iterable<NodeDto>>(){

            @Override
            public Iterable<NodeDto> call() throws Exception {
                String xmlResourceName = (String)xml.getValue();
                if (Strings.isNullOrBlank((String)xmlResourceName)) {
                    xmlResourceName = first;
                }
                List<ContextDto> camelContexts = CamelXmlHelper.loadCamelContext(AbstractCamelProjectCommand.this.camelCatalog, context, project, xmlResourceName);
                return NodeDtos.toNodeList(camelContexts);
            }
        });
    }

    protected boolean isProjectRequired() {
        return true;
    }

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelDeleteNodeXmlCommand.class).name("Camel: Delete Node XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Deletes a node from a Camel XML file");
    }

    public boolean isEnabled(UIContext context) {
        Project project;
        boolean enabled = super.isEnabled(context);
        if (!enabled) {
            return false;
        }
        if (this.requiresCamelSetup() && (project = this.getSelectedProjectOrNull(context)) != null) {
            return this.findCamelCoreDependency(project) != null;
        }
        return false;
    }

    protected Project getSelectedProjectOrNull(UIContext context) {
        return Projects.getSelectedProject((ProjectFactory)this.getProjectFactory(), (UIContext)context);
    }

    protected boolean requiresCamelSetup() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    protected ConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    protected CamelCatalog getCamelCatalog() {
        return this.camelCatalog;
    }

    protected PrintStream getOutput(UIExecutionContext context) {
        return context.getUIContext().getProvider().getOutput().out();
    }

    protected Dependency findCamelCoreDependency(Project project) {
        return CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    protected Set<Dependency> findCamelArtifacts(Project project) {
        return CamelProjectHelper.findCamelArtifacts((Project)project);
    }

    protected Coordinate createCoordinate(String groupId, String artifactId, String version) {
        CoordinateBuilder builder = CoordinateBuilder.create().setGroupId(groupId).setArtifactId(artifactId);
        if (version != null) {
            builder = builder.setVersion(version);
        }
        return builder;
    }

    protected Coordinate createCamelCoordinate(String artifactId, String version) {
        return this.createCoordinate("org.apache.camel", artifactId, version);
    }

    protected RouteBuilderEndpointsCompleter createRouteBuilderEndpointsCompleter(UIContext context) {
        Project project = this.getSelectedProject(context);
        return this.createRouteBuilderEndpointsCompleter(project);
    }

    protected RouteBuilderEndpointsCompleter createRouteBuilderEndpointsCompleter(Project project) {
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        return new RouteBuilderEndpointsCompleter(facet);
    }

    protected XmlEndpointsCompleter createXmlEndpointsCompleter(UIContext context) {
        Project project = this.getSelectedProject(context);
        return this.createXmlEndpointsCompleter(project);
    }

    protected XmlEndpointsCompleter createXmlEndpointsCompleter(Project project) {
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet);
    }

    protected XmlFileCompleter createXmlFileCompleter(Project project) {
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        return new XmlFileCompleter(resourcesFacet, webResourcesFacet);
    }

    protected XmlFileCompleter createXmlFileCompleter(UIContext context) {
        Project project = this.getSelectedProject(context);
        return this.createXmlFileCompleter(project);
    }

    protected FileResource getXmlResourceFile(Project project, String xmlResourceName) {
        FileResource file;
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        FileResource fileResource = file = facet != null ? facet.getResource(xmlResourceName) : null;
        if (file == null || !file.exists()) {
            file = webResourcesFacet != null ? webResourcesFacet.getWebResource(xmlResourceName) : null;
        }
        return file;
    }

    protected String configureXml(Project project, UISelectOne<String> xml) {
        XmlFileCompleter xmlFileCompleter = this.createXmlFileCompleter(project);
        Set<String> files = xmlFileCompleter.getFiles();
        String first = CollectionHelper.first(files);
        xml.setValueChoices(files);
        if (files.size() == 1) {
            xml.setDefaultValue((Object)first);
        }
        return first;
    }

    protected void configureComponentName(Project project, final UISelectOne<ComponentDto> componentName, boolean consumerOnly, boolean producerOnly) {
        componentName.setValueChoices(CamelCommandsHelper.createComponentDtoValues(project, this.getCamelCatalog(), null, false, consumerOnly, producerOnly));
        componentName.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String text) {
                return CamelCatalogHelper.createComponentDto(AbstractCamelProjectCommand.this.getCamelCatalog(), text);
            }
        });
        componentName.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String name) {
                return CamelCatalogHelper.createComponentDto(AbstractCamelProjectCommand.this.getCamelCatalog(), name);
            }
        });
        componentName.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                ComponentDto component = (ComponentDto)event.getNewValue();
                if (component != null) {
                    String description = component.getDescription();
                    componentName.setNote(description != null ? description : "");
                } else {
                    componentName.setNote("");
                }
            }
        });
    }

    protected Element getSelectedCamelElementNode(Project project, String xmlResourceName, String key) throws Exception {
        Node selectedNode;
        FileResource file = this.getXmlResourceFile(project, xmlResourceName);
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream(), (String)"camelContext,routes,rests", (String)"http://camel.apache.org/schema/spring");
        Element selectedElement = null;
        if (root != null && (selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key)) instanceof Element) {
            selectedElement = (Element)selectedNode;
        }
        return selectedElement;
    }
}

