/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlResourcesCamelEndpointsVisitor;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.facets.constraints.FacetConstraintType;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.visit.ResourceVisitor;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

@FacetConstraint(value={ResourcesFacet.class, WebResourcesFacet.class}, type=FacetConstraintType.OPTIONAL)
public class CamelAddEndpointXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="componentNameFilter", required=false, description="To filter components")
    private UISelectOne<String> componentNameFilter;
    @Inject
    @WithAttributes(label="componentName", required=true, description="Name of component type to add")
    private UISelectOne<String> componentName;
    @Inject
    @WithAttributes(label="instanceName", required=true, description="Name of endpoint instance to add")
    private UIInput<String> instanceName;
    @Inject
    @WithAttributes(label="file", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddEndpointXmlCommand.class).name("Camel: Add Endpoint XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel endpoint to an existing XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        final ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        this.componentNameFilter.setValueChoices(CamelCommandsHelper.createComponentNameValues(project));
        this.componentNameFilter.setDefaultValue((Object)"<all>");
        this.componentName.setValueChoices(CamelCommandsHelper.createComponentNameValues(project, this.componentNameFilter, false));
        this.instanceName.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String value = (String)CamelAddEndpointXmlCommand.this.componentName.getValue();
                if (value != null) {
                    value = value.replaceAll("-", "");
                }
                ArrayList<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();
                XmlResourcesCamelEndpointsVisitor visitor = new XmlResourcesCamelEndpointsVisitor(resourcesFacet, endpoints);
                resourcesFacet.visitResources((ResourceVisitor)visitor);
                for (CamelEndpointDetails det : endpoints) {
                    if (det.getEndpointInstance() == null || !det.getEndpointInstance().equals(CamelAddEndpointXmlCommand.this.instanceName)) continue;
                    return null;
                }
                return value;
            }
        });
        this.xml.setValueChoices(new XmlFileCompleter(resourcesFacet, webResourcesFacet).getFiles());
        builder.add(this.componentNameFilter).add(this.componentName).add(this.instanceName).add(this.xml);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put("componentName", this.componentName.getValue());
        attributeMap.put("instanceName", this.instanceName.getValue());
        attributeMap.put("xml", this.xml.getValue());
        attributeMap.put("kind", "xml");
        return Results.navigateTo(ConfigureEndpointPropertiesStep.class);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

