/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.jolokia;

import io.fabric8.forge.camel.commands.jolokia.AbstractJolokiaCommand;
import io.fabric8.forge.camel.commands.jolokia.CamelContextCompleter;
import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import javax.inject.Inject;
import org.apache.camel.commands.CamelController;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class EndpointListCommand
extends AbstractJolokiaCommand {
    @Inject
    @WithAttributes(label="name", required=true, description="The name of the Camel context")
    private UIInput<String> name;
    @Inject
    @WithAttributes(label="decode", required=false, defaultValue="true", description="Whether to decode the endpoint uri so its human readable")
    private UIInput<String> decode;
    @Inject
    @WithAttributes(label="explain", required=false, defaultValue="false", description="Whether to explain the endpoint options")
    private UIInput<String> explain;
    @Inject
    @WithAttributes(label="verbose", required=false, defaultValue="false", description="Verbose output")
    private UIInput<String> verbose;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("camel-endpoint-list").category(Categories.create((String[])new String[]{CATEGORY})).description("List all endpoints available in a CamelContext");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.name.setCompleter((UICompleter)new CamelContextCompleter(this.getController()));
        builder.add(this.name).add(this.decode).add(this.explain).add(this.verbose);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String url = this.getJolokiaUrl();
        if (url == null) {
            return Results.fail((String)"Not connected to remote jolokia agent. Use camel-connect command first");
        }
        boolean val = "true".equals(this.decode.getValue());
        boolean val2 = "true".equals(this.verbose.getValue());
        boolean val3 = "true".equals(this.explain.getValue());
        org.apache.camel.commands.EndpointListCommand command = new org.apache.camel.commands.EndpointListCommand((String)this.name.getValue(), val, val2, val3);
        command.execute((CamelController)this.getController(), this.getOutput(context), this.getError(context));
        return Results.success();
    }
}

