/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.addon.utils.LineNumberHelper;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.util.IntrospectionSupport;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizardStep;
import org.jboss.forge.roaster.model.util.Strings;

public abstract class ConfigureEipPropertiesStep
extends AbstractCamelProjectCommand
implements UIWizardStep {
    private final CamelCatalog camelCatalog;
    private final String eipName;
    private final String group;
    private final List<InputComponent> allInputs;
    private final List<InputComponent> inputs;
    private final boolean last;
    private final int index;
    private final int total;

    public ConfigureEipPropertiesStep(ProjectFactory projectFactory, CamelCatalog camelCatalog, String eipName, String group, List<InputComponent> allInputs, List<InputComponent> inputs, boolean last, int index, int total) {
        this.projectFactory = projectFactory;
        this.camelCatalog = camelCatalog;
        this.eipName = eipName;
        this.group = group;
        this.allInputs = allInputs;
        this.inputs = inputs;
        this.last = last;
        this.index = index + 1;
        this.total = total;
    }

    public String getGroup() {
        return this.group;
    }

    public int getIndex() {
        return this.index;
    }

    public int getTotal() {
        return this.total;
    }

    public String getEipName() {
        return this.eipName;
    }

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConfigureEipPropertiesStep.class).name("Camel: EIP options").category(Categories.create((String[])new String[]{CATEGORY})).description(String.format("Configure %s options (%s of %s)", this.group, this.index, this.total));
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        if (this.inputs != null) {
            for (InputComponent input : this.inputs) {
                builder.add(input);
            }
        }
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        if (this.last) {
            String kind = ConfigureEipPropertiesStep.mandatoryAttributeValue(attributeMap, "kind");
            if ("xml".equals(kind)) {
                return this.executeXml(context, attributeMap);
            }
            throw new UnsupportedOperationException("Java not yet supported");
        }
        return null;
    }

    protected Result executeXml(UIExecutionContext context, Map<Object, Object> attributeMap) throws Exception {
        FileResource file;
        Dependency core;
        String mode = ConfigureEipPropertiesStep.mandatoryAttributeValue(attributeMap, "mode");
        String xml = ConfigureEipPropertiesStep.mandatoryAttributeValue(attributeMap, "xml");
        String pattern = ConfigureEipPropertiesStep.mandatoryAttributeValue(attributeMap, "pattern");
        String lineNumber = ConfigureEipPropertiesStep.mandatoryAttributeValue(attributeMap, "lineNumber");
        String lineNumberEnd = ConfigureEipPropertiesStep.mandatoryAttributeValue(attributeMap, "lineNumberEnd");
        Project project = this.getSelectedProject((UIContextProvider)context);
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        if ((core = CamelProjectHelper.findCamelCoreDependency((Project)project)) == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        HashMap<String, String> options = new HashMap<String, String>();
        HashMap<String, String> expressionKeys = new HashMap<String, String>();
        HashMap<String, String> expressionValues = new HashMap<String, String>();
        for (InputComponent input : this.allInputs) {
            String value;
            String key = input.getName();
            boolean expressionKey = CamelCatalogHelper.isModelExpressionKind(this.camelCatalog, this.eipName, key);
            boolean expressionValue = key.endsWith("_value");
            if (input.hasValue()) {
                boolean matchDefault;
                value = input.getValue().toString();
                if (value == null || (matchDefault = CamelCatalogHelper.isModelDefaultValue(this.camelCatalog, this.eipName, key, value))) continue;
                if (expressionKey) {
                    expressionKeys.put(key, value);
                    continue;
                }
                if (expressionValue) {
                    expressionValues.put(key, value);
                    continue;
                }
                options.put(key, value);
                continue;
            }
            if (!input.isRequired() || !input.hasDefaultValue() || (value = input.getValue().toString()) == null) continue;
            if (expressionKey) {
                expressionKeys.put(key, value);
                continue;
            }
            if (expressionValue) {
                expressionValues.put(key, value);
                continue;
            }
            options.put(key, value);
        }
        String javaType = CamelCatalogHelper.getModelJavaType(this.camelCatalog, this.eipName);
        if (javaType == null) {
            return Results.fail((String)("Cannot find javaType for " + this.eipName));
        }
        String modelXml = null;
        try {
            ClassLoader cl = CamelCatalog.class.getClassLoader();
            Class<?> clazz = cl.loadClass(javaType);
            Object instance = clazz.newInstance();
            IntrospectionSupport.setProperties(instance, options);
            for (Map.Entry entry : expressionKeys.entrySet()) {
                String name = (String)entry.getKey();
                String language = (String)entry.getValue();
                String text = (String)expressionValues.get(name + "_value");
                String lanJavaType = CamelCatalogHelper.getModelJavaType(this.camelCatalog, language);
                if (lanJavaType == null) continue;
                Class<?> clazz2 = cl.loadClass(lanJavaType);
                Object instance2 = clazz2.newInstance();
                IntrospectionSupport.setProperty(instance2, (String)"expression", (Object)text);
                IntrospectionSupport.setProperty(instance, (String)name, instance2);
            }
            modelXml = CamelXmlHelper.dumpModelAsXml(instance, cl);
        }
        catch (Exception cl) {
            // empty catch block
        }
        if (modelXml == null) {
            return Results.fail((String)"Cannot create XML model of the node");
        }
        FileResource fileResource = file = facet != null ? facet.getResource(xml) : null;
        if (file == null || !file.exists()) {
            FileResource fileResource2 = file = webResourcesFacet != null ? webResourcesFacet.getWebResource(xml) : null;
        }
        if (file == null || !file.exists()) {
            return Results.fail((String)("Cannot find XML file " + xml));
        }
        return this.addOrEditModelXml(file, pattern, modelXml, xml, lineNumber, lineNumberEnd, mode);
    }

    protected Result addOrEditModelXml(FileResource file, String pattern, String modelXml, String xml, String lineNumber, String lineNumberEnd, String mode) throws Exception {
        List lines = LineNumberHelper.readLines((InputStream)file.getResourceInputStream());
        if ("add".equals(mode)) {
            return this.addModelXml(pattern, lines, lineNumber, lineNumberEnd, modelXml, file, xml);
        }
        return this.editModelXml(pattern, lines, lineNumber, lineNumberEnd, modelXml, file, xml);
    }

    protected abstract Result addModelXml(String var1, List<String> var2, String var3, String var4, String var5, FileResource var6, String var7) throws Exception;

    protected abstract Result editModelXml(String var1, List<String> var2, String var3, String var4, String var5, FileResource var6, String var7) throws Exception;

    public static String mandatoryAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        throw new IllegalArgumentException("The attribute value '" + name + "' did not get passed on from the previous wizard page");
    }

    public static String optionalAttributeValue(Map<Object, Object> attributeMap, String name) {
        String text;
        Object value = attributeMap.get(name);
        if (value != null && !Strings.isBlank((String)(text = value.toString()))) {
            return text;
        }
        return null;
    }
}

