/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.AddRouteFromEndpointXmlStep;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.InputOptionByGroup;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class CamelAddRouteXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Name", required=false, description="The name of the new route")
    private UIInput<String> id;
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of component to use for the endpoint")
    private UISelectOne<ComponentDto> componentName;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddRouteXmlCommand.class).name("Camel: Add Route XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel route to an existing XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Map attributeMap = builder.getUIContext().getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(builder.getUIContext());
        this.configureComponentName(project, this.componentName, true, false);
        this.configureXml(project, this.xml);
        builder.add(this.xml).add(this.id).add(this.componentName);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put("xml", this.xml.getValue());
        attributeMap.put("mode", "add");
        attributeMap.put("kind", "xml");
        ComponentDto component = (ComponentDto)this.componentName.getValue();
        String camelComponentName = component.getScheme();
        String previous = (String)attributeMap.get("componentName");
        if (previous != null && previous.equals(camelComponentName) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        attributeMap.put("componentName", camelComponentName);
        boolean consumerOnly = true;
        boolean producerOnly = false;
        UIContext ui = context.getUIContext();
        List<InputOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, null, 20, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
        ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
        for (InputOptionByGroup group : groups) {
            allInputs.addAll(group.getInputs());
        }
        NavigationResultBuilder builder = Results.navigationBuilder();
        int pages = groups.size();
        for (int i = 0; i < pages; ++i) {
            boolean last = i == pages - 1;
            InputOptionByGroup current = groups.get(i);
            AddRouteFromEndpointXmlStep step = new AddRouteFromEndpointXmlStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages, (String)this.id.getValue());
            builder.add((UICommand)step);
        }
        NavigationResult navigationResult2 = builder.build();
        attributeMap.put("navigationResult", navigationResult2);
        return navigationResult2;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

