/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import io.fabric8.forge.addon.utils.CamelProjectHelper;
import io.fabric8.forge.camel.commands.project.dto.LanguageDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.JSonSchemaHelper;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;

public class CamelLanguagesCompleter
implements UICompleter<LanguageDto> {
    private final Project project;
    private final CamelCatalog camelCatalog;
    private final Dependency core;

    public CamelLanguagesCompleter(Project project, CamelCatalog camelCatalog) {
        this.project = project;
        this.camelCatalog = camelCatalog;
        this.core = CamelProjectHelper.findCamelCoreDependency((Project)project);
    }

    public Iterable<LanguageDto> getCompletionProposals(UIContext context, InputComponent input, String value) {
        if (this.core == null) {
            return null;
        }
        ArrayList<LanguageDto> answer = new ArrayList<LanguageDto>();
        List names = this.camelCatalog.findLanguageNames();
        ArrayList<String> filtered = new ArrayList<String>();
        for (String name : names) {
            if (value != null && !name.startsWith(value)) continue;
            filtered.add(name);
        }
        for (String name : filtered) {
            String json = this.camelCatalog.languageJSonSchema(name);
            String artifactId = CamelLanguagesCompleter.findArtifactId(json);
            boolean already = false;
            if (artifactId != null) {
                already = CamelProjectHelper.hasDependency((Project)this.project, (String)"org.apache.camel", (String)artifactId);
            }
            if (already) continue;
            LanguageDto dto = CamelCatalogHelper.createLanguageDto(this.camelCatalog, json);
            answer.add(dto);
        }
        return answer;
    }

    public Iterable<LanguageDto> getValueChoices() {
        if (this.core == null) {
            return null;
        }
        List names = this.camelCatalog.findLanguageNames();
        Set artifacts = CamelProjectHelper.findCamelArtifacts((Project)this.project);
        for (Dependency dep : artifacts) {
            Set<String> languages = CamelCatalogHelper.languagesFromArtifact(this.camelCatalog, dep.getCoordinate().getArtifactId());
            names.removeAll(languages);
        }
        ArrayList<LanguageDto> answer = new ArrayList<LanguageDto>();
        for (String name : names) {
            LanguageDto dto = CamelCatalogHelper.createLanguageDto(this.camelCatalog, name);
            answer.add(dto);
        }
        return answer;
    }

    private static String findArtifactId(String json) {
        List data = JSonSchemaHelper.parseJsonSchema((String)"language", (String)json, (boolean)false);
        for (Map row : data) {
            if (row.get("artifactId") == null) continue;
            return (String)row.get("artifactId");
        }
        return null;
    }
}

