/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.EditFromOrToEndpointXmlStep;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.model.EndpointOptionByGroup;
import io.fabric8.utils.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.command.UICommand;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.InputComponentFactory;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.result.navigation.NavigationResultBuilder;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;
import org.w3c.dom.Element;

public class CamelEditNodeXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Node", required=true, description="Node to edit")
    private UISelectOne<NodeDto> node;
    @Inject
    @WithAttributes(label="Name", required=false, description="The name of the step")
    private UIInput<String> id;
    @Inject
    @WithAttributes(label="Description", required=false, description="The description of the step")
    private UIInput<String> description;
    @Inject
    private InputComponentFactory componentFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelEditNodeXmlCommand.class).name("Camel: Edit Node XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Edits a node in a Camel XML file");
    }

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        UIContext context = builder.getUIContext();
        Map attributeMap = context.getAttributeMap();
        attributeMap.remove("navigationResult");
        Project project = this.getSelectedProject(context);
        String first = this.configureXml(project, this.xml);
        this.node.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                NodeDto value = (NodeDto)CamelEditNodeXmlCommand.this.node.getValue();
                if (value != null) {
                    CamelEditNodeXmlCommand.this.id.setValue((Object)value.getId());
                    CamelEditNodeXmlCommand.this.description.setValue((Object)value.getDescription());
                }
            }
        });
        CamelEditNodeXmlCommand.configureNode(context, project, first, this.xml, this.node);
        builder.add(this.xml).add(this.node);
        builder.add(this.xml).add(this.id).add(this.description);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        NavigationResult navigationResult;
        Project project = this.getSelectedProject((UIContextProvider)context);
        Map attributeMap = context.getUIContext().getAttributeMap();
        String xmlResourceName = (String)this.xml.getValue();
        attributeMap.put("xml", xmlResourceName);
        attributeMap.put("mode", "add");
        attributeMap.put("kind", "xml");
        NodeDto editNode = (NodeDto)this.node.getValue();
        String key = editNode.getKey();
        String pattern = editNode.getPattern();
        String previous = this.getNodeKey(attributeMap.get("node"));
        if (previous != null && previous.equals(previous) && (navigationResult = (NavigationResult)attributeMap.get("navigationResult")) != null) {
            return navigationResult;
        }
        attributeMap.put("node", key);
        if (pattern.equals("from") || pattern.equals("to")) {
            boolean consumerOnly = false;
            boolean producerOnly = false;
            boolean isFrom = false;
            if (pattern.equals("from")) {
                consumerOnly = true;
                isFrom = true;
            } else {
                producerOnly = true;
            }
            Element selectedElement = this.getSelectedElementNode(project, xmlResourceName, key);
            if (selectedElement == null) {
                throw new IllegalArgumentException("Could not find xml for node " + editNode);
            }
            String uri = selectedElement.getAttribute("uri");
            if (Strings.isNullOrBlank((String)uri)) {
                throw new IllegalArgumentException("No uri property for node " + editNode);
            }
            String[] split = uri.split(":");
            String camelComponentName = split[0];
            System.out.println("Using endpoint " + uri + " and componentName: " + camelComponentName);
            attributeMap.put("componentName", camelComponentName);
            attributeMap.put("endpointUri", uri);
            UIContext ui = context.getUIContext();
            List<EndpointOptionByGroup> groups = CamelCommandsHelper.createUIInputsForCamelComponent(camelComponentName, uri, 20, consumerOnly, producerOnly, this.getCamelCatalog(), this.componentFactory, this.converterFactory, ui);
            ArrayList<InputComponent> allInputs = new ArrayList<InputComponent>();
            for (EndpointOptionByGroup group : groups) {
                allInputs.addAll(group.getInputs());
            }
            NavigationResultBuilder builder = Results.navigationBuilder();
            int pages = groups.size();
            for (int i = 0; i < pages; ++i) {
                boolean last = i == pages - 1;
                EndpointOptionByGroup current = groups.get(i);
                EditFromOrToEndpointXmlStep step = new EditFromOrToEndpointXmlStep(this.projectFactory, this.dependencyInstaller, this.getCamelCatalog(), camelComponentName, current.getGroup(), allInputs, current.getInputs(), last, i, pages, (String)this.id.getValue(), (String)this.description.getValue(), editNode, isFrom);
                builder.add((UICommand)step);
            }
            NavigationResult navigationResult2 = builder.build();
            attributeMap.put("navigationResult", navigationResult2);
            return navigationResult2;
        }
        return null;
    }

    private String getNodeKey(Object value) {
        if (value instanceof NodeDto) {
            NodeDto nodeDto = (NodeDto)value;
            return nodeDto.getKey();
        }
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

