/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelAddComponentCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Filter", required=false, description="To filter components")
    private UISelectOne<String> filter;
    @Inject
    @WithAttributes(label="Name", required=true, description="Name of component type to add")
    private UISelectOne<ComponentDto> name;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddComponentCommand.class).name("Camel: Add Component").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel component to your project dependencies");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)builder);
        this.filter.setValueChoices(CamelCommandsHelper.createComponentLabelValues(project, this.getCamelCatalog()));
        this.filter.setDefaultValue((Object)"<all>");
        this.name.setValueChoices(CamelCommandsHelper.createAllComponentDtoValues(project, this.getCamelCatalog(), this.filter, true));
        this.name.setValueConverter((Converter)new Converter<String, ComponentDto>(){

            public ComponentDto convert(String text) {
                return CamelCatalogHelper.createComponentDto(CamelAddComponentCommand.this.getCamelCatalog(), text);
            }
        });
        this.name.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                ComponentDto component = (ComponentDto)event.getNewValue();
                if (component != null) {
                    String description = component.getDescription();
                    CamelAddComponentCommand.this.name.setNote(description != null ? description : "");
                } else {
                    CamelAddComponentCommand.this.name.setNote("");
                }
            }
        });
        builder.add(this.filter).add(this.name);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        ComponentDto dto = (ComponentDto)this.name.getValue();
        if (dto != null) {
            String version = "org.apache.camel".equals(dto.getGroupId()) ? core.getCoordinate().getVersion() : dto.getVersion();
            DependencyBuilder component = DependencyBuilder.create().setGroupId(dto.getGroupId()).setArtifactId(dto.getArtifactId()).setVersion(version);
            this.dependencyInstaller.install(project, (Dependency)component);
            return Results.success((String)("Added Camel component " + dto.getScheme() + " (" + dto.getArtifactId() + ") to the project"));
        }
        return Results.fail((String)"Unknown Camel component");
    }
}

