/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.converter;

import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtos;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.UISelectOne;

public class NodeDtoConverter
implements Converter<String, NodeDto> {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Project project;
    private final UIContext context;
    private final UISelectOne<String> xml;

    public NodeDtoConverter(Project project, UIContext context, UISelectOne<String> xml) {
        this.project = project;
        this.context = context;
        this.xml = xml;
    }

    public NodeDto convert(String name) {
        String xmlResourceName = (String)this.xml.getValue();
        NodeDto answer = null;
        try {
            List<ContextDto> camelContexts = CamelXmlHelper.loadCamelContext(this.context, this.project, xmlResourceName);
            answer = NodeDtos.findNodeByKey(camelContexts, name);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Caught " + e, e);
        }
        System.out.println("converting node key '" + name + "' to a node: " + answer);
        return answer;
    }
}

