/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.CamelCurrentComponentsFinder;
import io.fabric8.forge.camel.commands.project.completer.RouteBuilderEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.completer.XmlEndpointsCompleter;
import io.fabric8.forge.camel.commands.project.dto.ComponentDto;
import io.fabric8.forge.camel.commands.project.dto.EndpointDto;
import io.fabric8.forge.camel.commands.project.dto.OutputFormat;
import io.fabric8.forge.camel.commands.project.dto.ProjectDto;
import io.fabric8.forge.camel.commands.project.helper.OutputFormatHelper;
import io.fabric8.utils.TablePrinter;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.projects.facets.WebResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelGetOverviewCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="Format", defaultValue="Text", description="Format output as text or json")
    private UISelectOne<OutputFormat> format;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelGetOverviewCommand.class).name("Camel: Get Overview").category(Categories.create((String[])new String[]{CATEGORY})).description("Gets the overview of the project from a camel perspective");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        builder.add(this.format);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        ProjectDto camelProject = new ProjectDto();
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        WebResourcesFacet webResourcesFacet = null;
        if (project.hasFacet(WebResourcesFacet.class)) {
            webResourcesFacet = (WebResourcesFacet)project.getFacet(WebResourcesFacet.class);
        }
        XmlEndpointsCompleter xmlEndpointCompleter = new XmlEndpointsCompleter(resourcesFacet, webResourcesFacet);
        JavaSourceFacet javaSourceFacet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        RouteBuilderEndpointsCompleter javaEndpointsCompleter = new RouteBuilderEndpointsCompleter(javaSourceFacet);
        camelProject.addEndpoints(javaEndpointsCompleter.getEndpoints());
        camelProject.addEndpoints(xmlEndpointCompleter.getEndpoints());
        CamelCurrentComponentsFinder componentsFinder = new CamelCurrentComponentsFinder(this.getCamelCatalog(), project);
        List<ComponentDto> currentComponents = componentsFinder.findCurrentComponents();
        camelProject.setComponents(currentComponents);
        String result = this.formatResult(camelProject);
        return Results.success((String)result);
    }

    protected String formatResult(ProjectDto result) throws JsonProcessingException {
        OutputFormat outputFormat = (OutputFormat)((Object)this.format.getValue());
        switch (outputFormat) {
            case JSON: {
                return OutputFormatHelper.toJson(result);
            }
        }
        return this.textResult(result);
    }

    protected String textResult(ProjectDto camelProject) {
        List<EndpointDto> endpoints;
        StringBuilder buffer = new StringBuilder("\n\n");
        List<ComponentDto> components = camelProject.getComponents();
        if (!components.isEmpty()) {
            TablePrinter table = new TablePrinter();
            table.columns(new String[]{"scheme", "syntax", "description"});
            for (ComponentDto component : components) {
                table.row(new String[]{component.getScheme(), component.getSyntax(), component.getDescription()});
            }
            OutputFormatHelper.addTableTextOutput(buffer, "Components", table);
        }
        if (!(endpoints = camelProject.getEndpoints()).isEmpty()) {
            TablePrinter table = new TablePrinter();
            table.columns(new String[]{"uri", "instance name", "file name"});
            for (EndpointDto endpoint : endpoints) {
                table.row(new String[]{endpoint.getEndpointComponentName(), endpoint.getEndpointInstance(), endpoint.getFileName()});
            }
            OutputFormatHelper.addTableTextOutput(buffer, "Endpoints", table);
        }
        return buffer.toString();
    }
}

