/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.XmlLineNumberParser;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import io.fabric8.forge.camel.commands.project.converter.NodeDtoConverter;
import io.fabric8.forge.camel.commands.project.converter.NodeDtoLabelConverter;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtos;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelXmlHelper;
import io.fabric8.forge.camel.commands.project.helper.CollectionHelper;
import io.fabric8.utils.DomHelper;
import io.fabric8.utils.Strings;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.convert.Converter;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CamelDeleteNodeXmlCommand
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Node", required=true, description="Node to delete")
    private UISelectOne<NodeDto> node;
    @Inject
    private DependencyInstaller dependencyInstaller;

    @Override
    public boolean isEnabled(UIContext context) {
        boolean enabled = super.isEnabled(context);
        if (enabled) {
            boolean spring = CamelCommandsHelper.isSpringProject(this.getSelectedProject(context));
            boolean blueprint = CamelCommandsHelper.isBlueprintProject(this.getSelectedProject(context));
            return spring || blueprint;
        }
        return false;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        final UIContext context = builder.getUIContext();
        final Project project = this.getSelectedProject(context);
        XmlFileCompleter xmlFileCompleter = this.createXmlFileCompleter(project);
        Set<String> files = xmlFileCompleter.getFiles();
        final String first = CollectionHelper.first(files);
        this.xml.setValueChoices(files);
        if (files.size() == 1) {
            this.xml.setDefaultValue((Object)first);
        }
        this.node.setValueConverter((Converter)new NodeDtoConverter(project, context, this.xml));
        this.node.setItemLabelConverter((Converter)new NodeDtoLabelConverter());
        this.node.setValueChoices((Callable)new Callable<Iterable<NodeDto>>(){

            @Override
            public Iterable<NodeDto> call() throws Exception {
                String xmlResourceName = (String)CamelDeleteNodeXmlCommand.this.xml.getValue();
                if (Strings.isNullOrBlank((String)xmlResourceName)) {
                    xmlResourceName = first;
                }
                List<ContextDto> camelContexts = CamelXmlHelper.loadCamelContext(context, project, xmlResourceName);
                return NodeDtos.toNodeList(camelContexts);
            }
        });
        builder.add(this.xml).add(this.node);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        NodeDto nodeValue = (NodeDto)this.node.getValue();
        if (nodeValue == null) {
            return Results.fail((String)"No node to delete!");
        }
        String key = nodeValue.getKey();
        if (Strings.isNullOrBlank((String)key)) {
            return Results.fail((String)"Selected node does not have a key so cannot delete it!");
        }
        String xmlResourceName = (String)this.xml.getValue();
        FileResource file = this.getXmlResourceFile(project, xmlResourceName);
        if (file == null || !file.exists()) {
            return Results.fail((String)("Cannot find XML file " + xmlResourceName));
        }
        List<ContextDto> camelContexts = CamelXmlHelper.loadCamelContext(context.getUIContext(), project, xmlResourceName);
        if (camelContexts == null) {
            return Results.fail((String)("No file found for: " + xmlResourceName));
        }
        Document root = XmlLineNumberParser.parseXml((InputStream)file.getResourceInputStream());
        if (root != null) {
            Node selectedNode = CamelXmlHelper.findCamelNodeInDocument(root, key);
            if (selectedNode != null) {
                DomHelper.detach((Node)selectedNode);
                String content = DomHelper.toXml((Document)root);
                file.setContents(content);
                return Results.success((String)"Node deleted");
            }
            return Results.fail((String)("Cannot find Camel node in XML file " + nodeValue));
        }
        return Results.fail((String)("Could not load camel XML " + xmlResourceName));
    }
}

