/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import io.fabric8.forge.camel.commands.project.helper.CamelCatalogHelper;
import io.fabric8.forge.camel.commands.project.helper.CamelJavaParserHelper;
import io.fabric8.forge.camel.commands.project.helper.ParserResult;
import io.fabric8.forge.camel.commands.project.model.CamelEndpointDetails;
import io.fabric8.forge.camel.commands.project.model.CamelSimpleDetails;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.ASTNode;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.Expression;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.MemberValuePair;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.NormalAnnotation;
import org.jboss.forge.roaster._shade.org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.jboss.forge.roaster.model.Annotation;
import org.jboss.forge.roaster.model.source.FieldSource;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.MethodSource;

public class RouteBuilderParser {
    public static void parseRouteBuilderEndpoints(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelEndpointDetails> endpoints) {
        RouteBuilderParser.parseRouteBuilderEndpoints(clazz, baseDir, fullyQualifiedFileName, endpoints, null);
    }

    public static void parseRouteBuilderEndpoints(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelEndpointDetails> endpoints, List<String> unparsable) {
        for (FieldSource field : clazz.getFields()) {
            int pos;
            int line;
            String uri = null;
            for (Annotation ann : field.getAnnotations()) {
                boolean valid = "org.apache.camel.EndpointInject".equals(ann.getQualifiedName()) || "org.apache.camel.cdi.Uri".equals(ann.getQualifiedName());
                if (!valid) continue;
                Expression exp = (Expression)ann.getInternal();
                if (exp instanceof SingleMemberAnnotation) {
                    exp = ((SingleMemberAnnotation)exp).getValue();
                } else if (exp instanceof NormalAnnotation) {
                    List values = ((NormalAnnotation)exp).values();
                    for (Object value : values) {
                        MemberValuePair pair = (MemberValuePair)value;
                        if (!"uri".equals(pair.getName().toString())) continue;
                        exp = pair.getValue();
                        break;
                    }
                }
                uri = CamelJavaParserHelper.getLiteralValue(clazz, null, exp);
            }
            if (uri == null || RouteBuilderParser.findEndpointByUri(endpoints, uri) != null) continue;
            String fileName = fullyQualifiedFileName;
            if (fileName.startsWith(baseDir)) {
                fileName = fileName.substring(baseDir.length() + 1);
            }
            String id = field.getName();
            CamelEndpointDetails detail = new CamelEndpointDetails();
            detail.setFileName(fileName);
            detail.setClassName(clazz.getQualifiedName());
            detail.setEndpointInstance(id);
            detail.setEndpointUri(uri);
            detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(uri));
            Object internal = field.getInternal();
            if (internal instanceof ASTNode && (line = RouteBuilderParser.findLineNumber(fullyQualifiedFileName, pos = ((ASTNode)internal).getStartPosition())) > -1) {
                detail.setLineNumber("" + line);
            }
            endpoints.add(detail);
        }
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            CamelEndpointDetails detail;
            List<ParserResult> uris = CamelJavaParserHelper.parseCamelConsumerUris(method, true, true);
            for (ParserResult result : uris) {
                if (!result.isParsed() && unparsable != null) {
                    unparsable.add(result.getElement());
                    continue;
                }
                detail = RouteBuilderParser.findEndpointByUri(endpoints, result.getElement());
                if (detail != null) {
                    detail.setConsumerOnly(true);
                    continue;
                }
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                detail = new CamelEndpointDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName("configure");
                detail.setEndpointInstance(null);
                detail.setEndpointUri(result.getElement());
                int line = RouteBuilderParser.findLineNumber(fullyQualifiedFileName, result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(result.getElement()));
                detail.setConsumerOnly(true);
                detail.setProducerOnly(false);
                endpoints.add(detail);
            }
            uris = CamelJavaParserHelper.parseCamelProducerUris(method, true, true);
            for (ParserResult result : uris) {
                String fileName;
                if (!result.isParsed() && unparsable != null) {
                    unparsable.add(result.getElement());
                    continue;
                }
                detail = RouteBuilderParser.findEndpointByUri(endpoints, result.getElement());
                if (detail != null) {
                    if (detail.isConsumerOnly()) {
                        detail.setConsumerOnly(false);
                        detail.setProducerOnly(false);
                    } else {
                        detail.setProducerOnly(true);
                    }
                }
                if ((fileName = fullyQualifiedFileName).startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                detail = new CamelEndpointDetails();
                detail.setFileName(fileName);
                detail.setClassName(clazz.getQualifiedName());
                detail.setMethodName("configure");
                detail.setEndpointInstance(null);
                detail.setEndpointUri(result.getElement());
                int line = RouteBuilderParser.findLineNumber(fullyQualifiedFileName, result.getPosition());
                if (line > -1) {
                    detail.setLineNumber("" + line);
                }
                detail.setEndpointComponentName(CamelCatalogHelper.endpointComponentName(result.getElement()));
                detail.setConsumerOnly(false);
                detail.setProducerOnly(true);
                endpoints.add(detail);
            }
        }
    }

    private static CamelEndpointDetails findEndpointByUri(List<CamelEndpointDetails> endpoints, String uri) {
        for (CamelEndpointDetails detail : endpoints) {
            if (!uri.equals(detail.getEndpointUri())) continue;
            return detail;
        }
        return null;
    }

    public static void parseRouteBuilderSimpleExpressions(JavaClassSource clazz, String baseDir, String fullyQualifiedFileName, List<CamelSimpleDetails> simpleExpressions) {
        MethodSource<JavaClassSource> method = CamelJavaParserHelper.findConfigureMethod(clazz);
        if (method != null) {
            List<ParserResult> expressions = CamelJavaParserHelper.parseCamelSimpleExpressions(method);
            for (ParserResult result : expressions) {
                String fileName = fullyQualifiedFileName;
                if (fileName.startsWith(baseDir)) {
                    fileName = fileName.substring(baseDir.length() + 1);
                }
                CamelSimpleDetails details = new CamelSimpleDetails();
                details.setFileName(fileName);
                details.setClassName(clazz.getQualifiedName());
                details.setMethodName("configure");
                int line = RouteBuilderParser.findLineNumber(fullyQualifiedFileName, result.getPosition());
                if (line > -1) {
                    details.setLineNumber("" + line);
                }
                details.setSimple(result.getElement());
                simpleExpressions.add(details);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int findLineNumber(String fullyQualifiedFileName, int position) {
        int lines = 0;
        try {
            int current = 0;
            try (BufferedReader br = new BufferedReader(new FileReader(new File(fullyQualifiedFileName)));){
                String line;
                do {
                    if ((line = br.readLine()) == null) return lines;
                    ++lines;
                } while ((current += line.length() + 1) < position);
                int n = lines;
                return n;
            }
        }
        catch (Exception e) {
            return -1;
        }
    }
}

