/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.jboss.forge.addon.ui.input.UIInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CamelXmlHelper {
    public static Node findEndpointById(Document dom, String endpointId) {
        NodeList list = dom.getElementsByTagName("endpoint");
        for (int i = 0; i < list.getLength(); ++i) {
            String id;
            Node child = list.item(i);
            if (!"endpoint".equals(child.getNodeName()) || !endpointId.equals(id = child.getAttributes().getNamedItem("id").getNodeValue())) continue;
            return child;
        }
        return null;
    }

    public static List<Element> findAllContexts(Document dom) {
        ArrayList<Element> nodes = new ArrayList<Element>();
        NodeList list = dom.getElementsByTagName("camelContext");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node;
            NamedNodeMap attrs;
            Node child = list.item(i);
            String ns = child.getNamespaceURI();
            if (ns == null && (attrs = child.getAttributes()) != null && (node = attrs.getNamedItem("xmlns")) != null) {
                ns = node.getNodeValue();
            }
            if (ns != null && !ns.contains("camel") || !(child instanceof Element)) continue;
            nodes.add((Element)child);
        }
        return nodes;
    }

    public static List<Node> findAllEndpoints(Document dom) {
        Node child;
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("endpoint");
        for (i = 0; i < list.getLength(); ++i) {
            Node node;
            NamedNodeMap attrs;
            child = list.item(i);
            if (!"endpoint".equals(child.getNodeName())) continue;
            String ns = child.getNamespaceURI();
            if (ns == null && (attrs = child.getAttributes()) != null && (node = attrs.getNamedItem("xmlns")) != null) {
                ns = node.getNodeValue();
            }
            if (ns != null && !ns.contains("camel")) continue;
            nodes.add(child);
        }
        list = dom.getElementsByTagName("onException");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("onCompletion");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("intercept");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("interceptFrom");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("interceptSendToEndpoint");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("rest");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!"route".equals(child.getNodeName()) && !"to".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        list = dom.getElementsByTagName("route");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllUrisRecursive(Node node, List<Node> nodes) {
        NodeList children;
        String url = CamelXmlHelper.getSafeAttribute(node, "uri");
        if (url != null) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllUrisRecursive(child, nodes);
            }
        }
    }

    public static List<Node> findAllSimpleExpressions(Document dom) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("route");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllSimpleExpressionsRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllSimpleExpressionsRecursive(Node node, List<Node> nodes) {
        NodeList children;
        if ("simple".equals(node.getNodeName())) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllSimpleExpressionsRecursive(child, nodes);
            }
        }
    }

    public static String getSafeAttribute(Node node, String key) {
        Node attr;
        if (node != null && (attr = node.getAttributes().getNamedItem(key)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static String trimEndpointUri(String uri) {
        uri = uri.trim();
        uri = uri.replaceAll("(\\s+)(\\&)", "$2");
        uri = uri.replaceAll("(\\&)(\\s+)", "$1");
        uri = uri.replaceAll("(\\?)(\\s+)", "$1");
        return uri;
    }

    public static String createFileName(UIInput<String> directory, UIInput<String> name) {
        return directory.getValue() != null ? (String)directory.getValue() + File.separator + (String)name.getValue() : (String)name.getValue();
    }
}

