/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.camel.tooling.util.CamelModelHelper;
import io.fabric8.camel.tooling.util.RouteXml;
import io.fabric8.camel.tooling.util.Strings2;
import io.fabric8.camel.tooling.util.XmlModel;
import io.fabric8.forge.addon.utils.CommandHelpers;
import io.fabric8.forge.addon.utils.Indenter;
import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import io.fabric8.forge.camel.commands.project.dto.ContextDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDto;
import io.fabric8.forge.camel.commands.project.dto.NodeDtoSupport;
import io.fabric8.forge.camel.commands.project.dto.OutputFormat;
import io.fabric8.forge.camel.commands.project.dto.RouteDto;
import io.fabric8.forge.camel.commands.project.helper.CollectionHelper;
import io.fabric8.forge.camel.commands.project.helper.OutputFormatHelper;
import io.fabric8.utils.Block;
import io.fabric8.utils.Files;
import io.fabric8.utils.Strings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class CamelGetRoutesXmlCommand
extends AbstractCamelProjectCommand {
    private static Set<String> patternsToPrefix = new HashSet<String>(Arrays.asList("camelContext", "route", "from", "to"));
    @Inject
    @WithAttributes(label="XML File", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UISelectOne<String> xml;
    @Inject
    @WithAttributes(label="Format", defaultValue="Text", description="Format output as text or json")
    private UISelectOne<OutputFormat> format;
    @Inject
    private DependencyInstaller dependencyInstaller;
    private RouteXml routeXml = new RouteXml();

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelGetRoutesXmlCommand.class).name("Camel: Get Routes XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Gets the overview of the routes in a project for a given XML file");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        XmlFileCompleter xmlFileCompleter = this.createXmlFileCompleter(project);
        Set<String> files = xmlFileCompleter.getFiles();
        this.xml.setValueChoices(files);
        if (files.size() == 1) {
            this.xml.setDefaultValue((Object)CollectionHelper.first(files));
        }
        builder.add(this.xml).add(this.format);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        String xmlFileName = io.fabric8.forge.addon.utils.Files.joinPaths((String)"src/main/resources", (String)((String)this.xml.getValue()));
        File xmlFile = CommandHelpers.getProjectContextFile((UIContext)context.getUIContext(), (Project)project, (String)xmlFileName);
        if (!Files.isFile((File)xmlFile)) {
            return Results.fail((String)("No file found for: " + xmlFileName));
        }
        List<ContextDto> camelContexts = this.parseCamelContexts(xmlFile);
        String result = this.formatResult(camelContexts);
        return Results.success((String)result);
    }

    protected List<ContextDto> parseCamelContexts(File xmlFile) throws Exception {
        ArrayList<ContextDto> camelContexts = new ArrayList<ContextDto>();
        XmlModel xmlModel = this.routeXml.unmarshal(xmlFile);
        CamelContextFactoryBean context = xmlModel.getContextElement();
        String name = context.getId();
        List routeDefs = context.getRoutes();
        List<RouteDto> routes = this.createRouteDtos(routeDefs);
        camelContexts.add(new ContextDto(name, routes));
        return camelContexts;
    }

    protected List<RouteDto> createRouteDtos(List<RouteDefinition> routeDefs) {
        ArrayList<RouteDto> answer = new ArrayList<RouteDto>();
        for (RouteDefinition def : routeDefs) {
            RouteDto route = new RouteDto();
            route.setId(def.getId());
            route.setLabel(CamelModelHelper.getDisplayText((OptionalIdentifiedDefinition)def));
            route.setDescription(CamelModelHelper.getDescription((OptionalIdentifiedDefinition)def));
            CamelGetRoutesXmlCommand.addInputs(route, def.getInputs());
            CamelGetRoutesXmlCommand.addOutputs(route, def.getOutputs());
            answer.add(route);
        }
        return answer;
    }

    protected static void addInputs(NodeDto owner, List<FromDefinition> inputs) {
        for (FromDefinition input : inputs) {
            CamelGetRoutesXmlCommand.addChild(owner, (OptionalIdentifiedDefinition)input);
        }
    }

    protected static void addOutputs(NodeDto owner, List<ProcessorDefinition<?>> outputs) {
        for (ProcessorDefinition<?> output : outputs) {
            CamelGetRoutesXmlCommand.addChild(owner, output);
        }
    }

    private static NodeDto addChild(NodeDto owner, OptionalIdentifiedDefinition definition) {
        NodeDto node = new NodeDto();
        node.setId(definition.getId());
        node.setLabel(CamelModelHelper.getDisplayText((OptionalIdentifiedDefinition)definition));
        node.setDescription(CamelModelHelper.getDescription((OptionalIdentifiedDefinition)definition));
        node.setPattern(CamelModelHelper.getPatternName((OptionalIdentifiedDefinition)definition));
        if (definition instanceof ProcessorDefinition) {
            ProcessorDefinition processorDefinition = (ProcessorDefinition)definition;
            CamelGetRoutesXmlCommand.addOutputs(node, processorDefinition.getOutputs());
        }
        owner.addChild(node);
        return node;
    }

    protected String formatResult(List<ContextDto> result) throws Exception {
        OutputFormat outputFormat = (OutputFormat)((Object)this.format.getValue());
        switch (outputFormat) {
            case JSON: {
                return OutputFormatHelper.toJson(result);
            }
        }
        return this.textResult(result);
    }

    protected String textResult(List<ContextDto> camelContexts) throws Exception {
        StringBuilder buffer = new StringBuilder("\n\n");
        Indenter out = new Indenter((Appendable)buffer);
        for (ContextDto camelContext : camelContexts) {
            CamelGetRoutesXmlCommand.printNode(out, camelContext);
        }
        return buffer.toString();
    }

    protected static void printNode(final Indenter out, final NodeDtoSupport node) throws Exception {
        out.println(CamelGetRoutesXmlCommand.getNodeText(node));
        out.withIndent(new Block(){

            public void invoke() throws Exception {
                for (NodeDto child : node.getChildren()) {
                    CamelGetRoutesXmlCommand.printNode(out, child);
                }
            }
        });
    }

    protected static String getNodeText(NodeDtoSupport node) {
        String pattern = Strings2.getOrElse((Object)node.getPattern());
        String label = Strings2.getOrElse((Object)node.getLabel());
        if (patternsToPrefix.contains(pattern)) {
            return Strings.join((String)" ", (Object[])new Object[]{pattern, label});
        }
        return label;
    }
}

