/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.helper;

import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CamelXmlHelper {
    public static Node findEndpointById(Document dom, String endpointId) {
        NodeList list = dom.getElementsByTagName("endpoint");
        for (int i = 0; i < list.getLength(); ++i) {
            String id;
            Node child = list.item(i);
            if (!"endpoint".equals(child.getNodeName()) || !endpointId.equals(id = child.getAttributes().getNamedItem("id").getNodeValue())) continue;
            return child;
        }
        return null;
    }

    public static List<Node> findAllEndpoints(Document dom) {
        Node child;
        int i;
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("endpoint");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!"endpoint".equals(child.getNodeName())) continue;
            nodes.add(child);
        }
        list = dom.getElementsByTagName("route");
        for (i = 0; i < list.getLength(); ++i) {
            child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllUrisRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllUrisRecursive(Node node, List<Node> nodes) {
        NodeList children;
        String url = CamelXmlHelper.getSafeAttribute(node, "uri");
        if (url != null) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllUrisRecursive(child, nodes);
            }
        }
    }

    public static List<Node> findAllSimpleExpressions(Document dom) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeList list = dom.getElementsByTagName("route");
        for (int i = 0; i < list.getLength(); ++i) {
            Node child = list.item(i);
            if (!"route".equals(child.getNodeName())) continue;
            CamelXmlHelper.findAllSimpleExpressionsRecursive(child, nodes);
        }
        return nodes;
    }

    private static void findAllSimpleExpressionsRecursive(Node node, List<Node> nodes) {
        NodeList children;
        if ("simple".equals(node.getNodeName())) {
            nodes.add(node);
        }
        if ((children = node.getChildNodes()) != null) {
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                CamelXmlHelper.findAllSimpleExpressionsRecursive(child, nodes);
            }
        }
    }

    public static String getSafeAttribute(Node node, String key) {
        Node attr;
        if (node != null && (attr = node.getAttributes().getNamedItem(key)) != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public static String trimEndpointUri(String uri) {
        uri = uri.trim();
        uri = uri.replaceAll("(\\s+)(\\&)", "$2");
        uri = uri.replaceAll("(\\&)(\\s+)", "$1");
        uri = uri.replaceAll("(\\?)(\\s+)", "$1");
        return uri;
    }
}

