/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.addon.utils.validator.ClassNameValidator;
import io.fabric8.forge.camel.commands.project.AbstractDockerProjectCommand;
import io.fabric8.forge.camel.commands.project.FabricStepCommand;
import io.fabric8.forge.camel.commands.project.helper.DockerSetupHelper;
import io.fabric8.forge.camel.commands.project.helper.JubeSetupHelper;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.forge.addon.maven.projects.MavenFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.input.ValueChangeListener;
import org.jboss.forge.addon.ui.input.events.ValueChangeEvent;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.addon.ui.wizard.UIWizard;

public class JubeStepCommand
extends AbstractDockerProjectCommand
implements UIWizard {
    private String[] jarImages = new String[]{"fabric8/java"};
    private String[] bundleImages = new String[]{"fabric8/karaf-2.4"};
    private String[] warImages = new String[]{"fabric8/tomcat-8.0", "jboss/wildfly"};
    @Inject
    @WithAttributes(label="from", required=true, description="The jube image to use as base line")
    private UISelectOne<String> from;
    @Inject
    @WithAttributes(label="main", required=false, description="Main class to use for Java standalone")
    private UIInput<String> main;
    @Inject
    private DependencyInstaller dependencyInstaller;

    public boolean isEnabled(UIContext context) {
        return false;
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        context.getUIContext().getAttributeMap().put("prev", JubeStepCommand.class);
        return Results.navigateTo(FabricStepCommand.class);
    }

    public void initializeUI(final UIBuilder builder) throws Exception {
        String packaging = JubeStepCommand.getProjectPackaging(this.getSelectedProject((UIContextProvider)builder));
        ArrayList<String> choices = new ArrayList<String>();
        if (packaging == null || "jar".equals(packaging)) {
            choices.add(this.jarImages[0]);
        }
        if (packaging == null || "bundle".equals(packaging)) {
            choices.add(this.bundleImages[0]);
        }
        if (packaging == null || "war".equals(packaging)) {
            choices.add(this.warImages[0]);
            choices.add(this.warImages[1]);
        }
        this.from.setValueChoices(choices);
        this.from.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                builder.getUIContext().getAttributeMap().put("docker.from", event.getNewValue());
                JubeStepCommand.this.main.setRequired(JubeStepCommand.this.isMainRequired((String)event.getNewValue()));
            }
        });
        String existing = (String)builder.getUIContext().getAttributeMap().get("docker.from");
        if (existing == null) {
            if (choices.size() == 1) {
                this.from.setDefaultValue(choices.get(0));
            }
        } else {
            this.from.setDefaultValue((Object)existing);
        }
        if ((existing = (String)builder.getUIContext().getAttributeMap().get("docker.main")) == null) {
            existing = DockerSetupHelper.defaultMainClass(this.getSelectedProject((UIContextProvider)builder));
        }
        this.main.setDefaultValue((Object)existing);
        this.main.setRequired(this.isMainRequired((String)this.from.getValue()));
        this.main.addValidator((UIValidator)new ClassNameValidator(true));
        this.main.addValueChangeListener(new ValueChangeListener(){

            public void valueChanged(ValueChangeEvent event) {
                builder.getUIContext().getAttributeMap().put("docker.main", event.getNewValue());
            }
        });
        builder.add(this.from).add(this.main);
    }

    private boolean isMainRequired(String from) {
        for (String jar : this.jarImages) {
            if (!jar.equals(from)) continue;
            return true;
        }
        return false;
    }

    public Result execute(UIExecutionContext context) throws Exception {
        JubeSetupHelper.setupJube(this.dependencyInstaller, this.getSelectedProject((UIContextProvider)context), (String)this.from.getValue());
        DockerSetupHelper.setupDockerProperties(this.getSelectedProject((UIContextProvider)context), (String)this.from.getValue(), (String)this.main.getValue());
        return Results.success((String)("Adding Jube using image " + (String)this.from.getValue()));
    }

    private static String getProjectPackaging(Project project) {
        if (project != null) {
            MavenFacet maven = (MavenFacet)project.getFacet(MavenFacet.class);
            return maven.getModel().getPackaging();
        }
        return null;
    }
}

