/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.ProjectFactory;
import org.jboss.forge.addon.projects.facets.DependencyFacet;
import org.jboss.forge.addon.projects.ui.AbstractProjectCommand;
import org.jboss.forge.addon.ui.UIProvider;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.output.UIOutput;

public abstract class AbstractCamelCommand
extends AbstractProjectCommand {
    public static final String MVN_CAMEL_GROUPID = "org.apache.camel";
    private static final String MVN_CAMEL_CORE = "camel-core";
    public static String CATEGORY = "Camel";
    @Inject
    protected ProjectFactory projectFactory;
    protected UIProvider uiProvider;
    protected List<String> camelDepsInUse = null;
    protected String camelCoreVersion = null;

    protected boolean isProjectRequired() {
        return true;
    }

    protected ProjectFactory getProjectFactory() {
        return this.projectFactory;
    }

    protected UIProvider getUiProvider() {
        return this.uiProvider;
    }

    protected UIOutput getOutput() {
        UIProvider provider = this.getUiProvider();
        return provider != null ? provider.getOutput() : null;
    }

    protected PrintStream getOut() {
        UIOutput output = this.getOutput();
        if (output != null) {
            return output.out();
        }
        return System.out;
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        ArrayList<String> currentCamelDeps = new ArrayList<String>();
        Project selectedProject = this.getSelectedProject((UIContextProvider)builder);
        List dependencies = ((DependencyFacet)selectedProject.getFacet(DependencyFacet.class)).getEffectiveDependencies();
        for (Dependency d : dependencies) {
            if (!MVN_CAMEL_GROUPID.equals(d.getCoordinate().getGroupId())) continue;
            currentCamelDeps.add(d.getCoordinate().getArtifactId());
            if (!MVN_CAMEL_CORE.equals(d.getCoordinate().getArtifactId())) continue;
            this.camelCoreVersion = d.getCoordinate().getVersion();
        }
        Collections.sort(currentCamelDeps);
        this.camelDepsInUse = currentCamelDeps;
    }

    public String getCamelCoreVersion() {
        return this.camelCoreVersion;
    }
}

