/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.validator;

import org.jboss.forge.addon.parser.java.ui.validators.AbstractJLSUIValidator;
import org.jboss.forge.addon.parser.java.utils.ResultType;
import org.jboss.forge.addon.parser.java.utils.ValidationResult;

public class ResourceNameValidator
extends AbstractJLSUIValidator {
    private String extension;

    public ResourceNameValidator(String extension) {
        this.extension = extension;
    }

    protected ValidationResult validate(String s) {
        int min;
        if (s == null) {
            return new ValidationResult(ResultType.INFO);
        }
        if (this.extension != null && !s.endsWith("." + this.extension)) {
            return new ValidationResult(ResultType.ERROR, "The file name [" + s + "] must be a " + this.extension + " file");
        }
        int n = min = this.extension != null ? this.extension.length() + 2 : 1;
        if (s.length() < min) {
            return new ValidationResult(ResultType.ERROR, "The file name [" + s + "] must be at least " + min + " characters");
        }
        return new ValidationResult(ResultType.INFO);
    }
}

