/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.jolokia;

import io.fabric8.forge.camel.commands.jolokia.AbstractJolokiaCommand;
import io.fabric8.forge.camel.commands.jolokia.CamelContextCompleter;
import io.fabric8.forge.camel.commands.jolokia.ConnectCommand;
import javax.inject.Inject;
import org.apache.camel.commands.CamelController;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ContextInflightCommand
extends AbstractJolokiaCommand {
    @Inject
    @WithAttributes(label="name", required=true, description="The name of the Camel context")
    private UIInput<String> name;
    @Inject
    @WithAttributes(label="limit", required=false, defaultValue="0", description="To limit the number of exchanges shown")
    private UIInput<Integer> limit;
    @Inject
    @WithAttributes(label="sortByLongestDuration", required=false, defaultValue="false", description="true = sort by longest duration, false = sort by exchange id")
    private UIInput<Boolean> sortByLongestDuration;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectCommand.class).name("camel-context-inflight").category(Categories.create((String[])new String[]{CATEGORY})).description("List inflight exchanges.");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        this.name.setCompleter((UICompleter)new CamelContextCompleter(this.getController()));
        builder.add(this.name).add(this.limit).add(this.sortByLongestDuration);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String url = this.getJolokiaUrl();
        if (url == null) {
            return Results.fail((String)"Not connected to remote jolokia agent. Use camel-connect command first");
        }
        org.apache.camel.commands.ContextInflightCommand command = new org.apache.camel.commands.ContextInflightCommand((String)this.name.getValue(), ((Integer)this.limit.getValue()).intValue(), ((Boolean)this.sortByLongestDuration.getValue()).booleanValue());
        command.execute((CamelController)this.getController(), this.getOutput(context), this.getError(context));
        return Results.success();
    }
}

