/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.jolokia;

import io.fabric8.forge.camel.commands.jolokia.AbstractJolokiaCommand;
import org.apache.camel.commands.jolokia.JolokiaCamelController;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;

public class ConnectedCommand
extends AbstractJolokiaCommand {
    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(ConnectedCommand.class).name("camel-connected").category(Categories.create((String[])new String[]{CATEGORY})).description("Checks the connection to the Jolokia agent");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
    }

    public Result execute(UIExecutionContext uiExecutionContext) throws Exception {
        String url = this.getJolokiaUrl();
        if (url == null) {
            return Results.fail((String)"Not connected to remote jolokia agent. Use camel-connect command first");
        }
        String username = this.configuration.getString("CamelJolokiaUsername");
        JolokiaCamelController controller = this.getController();
        boolean ok = controller.ping();
        if (ok) {
            return Results.success((String)("Connected to " + url + (username != null ? " using " + username : "")));
        }
        return Results.fail((String)("Error connecting to " + url));
    }
}

