/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ConfigureEndpointPropertiesStep;
import io.fabric8.forge.camel.commands.project.completer.XmlFileCompleter;
import io.fabric8.forge.camel.commands.project.helper.CamelCommandsHelper;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.DependencyResolver;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ClassLoaderFacet;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UINavigationContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UISelectOne;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.NavigationResult;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.wizard.UIWizard;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class, ClassLoaderFacet.class})
public class CamelAddEndpointXmlCommand
extends AbstractCamelProjectCommand
implements UIWizard {
    @Inject
    @WithAttributes(label="componentNameFilter", required=false, description="To filter components")
    private UISelectOne<String> componentNameFilter;
    @Inject
    @WithAttributes(label="componentName", required=true, description="Name of component type to add")
    private UISelectOne<String> componentName;
    @Inject
    @WithAttributes(label="instanceName", required=true, description="Name of endpoint instance to add")
    private UISelectOne<String> instanceName;
    @Inject
    @WithAttributes(label="file", required=true, description="The XML file to use (either Spring or Blueprint)")
    private UIInput<String> xml;
    @Inject
    private DependencyInstaller dependencyInstaller;
    @Inject
    private DependencyResolver dependencyResolver;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddEndpointXmlCommand.class).name("Camel: Add Endpoint XML").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel endpoint to an existing XML file");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        ResourcesFacet resourcesFacet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        this.componentNameFilter.setValueChoices(CamelCommandsHelper.createComponentNameValues(project));
        this.componentNameFilter.setDefaultValue((Object)"<all>");
        this.componentName.setValueChoices(CamelCommandsHelper.createComponentNameValues(project, this.componentNameFilter, false));
        this.instanceName.setDefaultValue((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                String value = (String)CamelAddEndpointXmlCommand.this.componentName.getValue();
                if (value != null) {
                    value = value.replaceAll("-", "");
                }
                return value;
            }
        });
        this.xml.setCompleter((UICompleter)new XmlFileCompleter(resourcesFacet));
        builder.add(this.componentNameFilter).add(this.componentName).add(this.instanceName).add(this.xml);
    }

    public NavigationResult next(UINavigationContext context) throws Exception {
        Map attributeMap = context.getUIContext().getAttributeMap();
        attributeMap.put("componentName", this.componentName.getValue());
        attributeMap.put("instanceName", this.instanceName.getValue());
        attributeMap.put("xml", this.xml.getValue());
        attributeMap.put("kind", "xml");
        return Results.navigateTo(ConfigureEndpointPropertiesStep.class);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        return Results.success();
    }
}

