/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project.completer;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.roaster.model.JavaClass;

public class PackageNameCompleter
implements UICompleter<String> {
    private final Set<String> packageNames = new TreeSet<String>();

    public PackageNameCompleter(JavaSourceFacet facet) {
        facet.visitJavaSources(new JavaResourceVisitor(){

            public void visit(VisitContext context, JavaResource javaResource) {
                try {
                    JavaClass clazz = (JavaClass)javaResource.getJavaType();
                    String packageName = clazz.getPackage();
                    if (packageName != null) {
                        PackageNameCompleter.this.packageNames.add(packageName);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    public Iterable<String> getCompletionProposals(UIContext context, InputComponent input, String value) {
        ArrayList<String> answer = new ArrayList<String>();
        for (String name : this.packageNames) {
            if (value != null && !name.startsWith(value)) continue;
            answer.add(name);
        }
        return answer;
    }
}

