/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands.project;

import io.fabric8.forge.camel.commands.project.AbstractCamelProjectCommand;
import io.fabric8.forge.camel.commands.project.ClassNameValidator;
import io.fabric8.forge.camel.commands.project.PackageNameCompleter;
import io.fabric8.forge.camel.commands.project.PackageNameValidator;
import javax.inject.Inject;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.facets.constraints.FacetConstraint;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;
import org.jboss.forge.roaster.model.source.MethodSource;

@FacetConstraint(value={JavaSourceFacet.class, ResourcesFacet.class})
public class CamelAddRouteBuilder
extends AbstractCamelProjectCommand {
    @Inject
    @WithAttributes(label="targetPackage", required=false, description="The package name where this type will be created")
    private UIInput<String> targetPackage;
    @Inject
    @WithAttributes(label="name", required=true, description="Name of RouteBuilder class")
    private UIInput<String> name;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelAddRouteBuilder.class).name("Camel: New RouteBuilder").category(Categories.create((String[])new String[]{CATEGORY})).description("Adds a Camel RouteBuilder class to your project");
    }

    public void initializeUI(UIBuilder builder) throws Exception {
        Project project = this.getSelectedProject(builder.getUIContext());
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        this.targetPackage.setCompleter((UICompleter)new PackageNameCompleter(facet));
        this.targetPackage.addValidator((UIValidator)new PackageNameValidator());
        this.name.addValidator((UIValidator)new ClassNameValidator());
        builder.add(this.targetPackage).add(this.name);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        Project project = this.getSelectedProject((UIContextProvider)context);
        JavaSourceFacet facet = (JavaSourceFacet)project.getFacet(JavaSourceFacet.class);
        Dependency core = this.findCamelCoreDependency(project);
        if (core == null) {
            return Results.fail((String)"The project does not include camel-core");
        }
        String fqn = this.targetPackage.getValue() != null ? (String)this.targetPackage.getValue() + "." + (String)this.name.getValue() : (String)this.name.getValue();
        JavaResource existing = facet.getJavaResource(fqn);
        if (existing != null && existing.exists()) {
            return Results.fail((String)("A class with name " + fqn + " already exists"));
        }
        JavaClassSource javaClass = (JavaClassSource)Roaster.create(JavaClassSource.class);
        javaClass.setName((String)this.name.getValue());
        if (this.targetPackage.getValue() != null) {
            javaClass.setPackage((String)this.targetPackage.getValue());
        }
        javaClass.setSuperType("RouteBuilder");
        javaClass.addImport("org.apache.camel.builder.RouteBuilder");
        ((MethodSource)((MethodSource)javaClass.addMethod().setPublic()).setReturnTypeVoid().setName("configure")).setBody("// add routes here").addThrows(Exception.class);
        facet.saveJavaSource((JavaSource)javaClass);
        return Results.success((String)("Added RouteBuilder " + (String)this.name.getValue() + " to the project"));
    }
}

