/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge.camel.commands;

import com.jcabi.xml.XMLDocument;
import io.fabric8.forge.camel.api.CamelSupportedTechnologyEnum;
import io.fabric8.forge.camel.commands.AbstractCamelCommand;
import io.fabric8.forge.camel.commands.UIVersionCompleter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.MediaType;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.Uri;
import org.apache.commons.io.FileUtils;
import org.jboss.forge.addon.dependencies.Dependency;
import org.jboss.forge.addon.dependencies.builder.DependencyBuilder;
import org.jboss.forge.addon.parser.java.facets.JavaSourceFacet;
import org.jboss.forge.addon.parser.java.resources.JavaResource;
import org.jboss.forge.addon.parser.java.resources.JavaResourceVisitor;
import org.jboss.forge.addon.projects.Project;
import org.jboss.forge.addon.projects.dependencies.DependencyInstaller;
import org.jboss.forge.addon.projects.facets.ResourcesFacet;
import org.jboss.forge.addon.resource.FileResource;
import org.jboss.forge.addon.resource.Resource;
import org.jboss.forge.addon.resource.ResourceFactory;
import org.jboss.forge.addon.resource.URLResource;
import org.jboss.forge.addon.resource.visit.VisitContext;
import org.jboss.forge.addon.rest.ClientFactory;
import org.jboss.forge.addon.templates.Template;
import org.jboss.forge.addon.templates.TemplateFactory;
import org.jboss.forge.addon.templates.freemarker.FreemarkerTemplate;
import org.jboss.forge.addon.ui.context.UIBuilder;
import org.jboss.forge.addon.ui.context.UIContext;
import org.jboss.forge.addon.ui.context.UIContextProvider;
import org.jboss.forge.addon.ui.context.UIExecutionContext;
import org.jboss.forge.addon.ui.context.UIValidationContext;
import org.jboss.forge.addon.ui.input.InputComponent;
import org.jboss.forge.addon.ui.input.UICompleter;
import org.jboss.forge.addon.ui.input.UIInput;
import org.jboss.forge.addon.ui.input.UIPrompt;
import org.jboss.forge.addon.ui.metadata.UICommandMetadata;
import org.jboss.forge.addon.ui.metadata.WithAttributes;
import org.jboss.forge.addon.ui.result.Result;
import org.jboss.forge.addon.ui.result.Results;
import org.jboss.forge.addon.ui.util.Categories;
import org.jboss.forge.addon.ui.util.Metadata;
import org.jboss.forge.addon.ui.validate.UIValidator;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.jboss.forge.roaster.model.source.JavaSource;

public class CamelNewComponentsCommand
extends AbstractCamelCommand {
    @Inject
    @WithAttributes(label="Camel components to add to the project", description="Select the list of Camel component that you want to add to your project.", required=true)
    UIInput<String> named;
    @Inject
    @WithAttributes(label="Version", description="Version.", required=true)
    UIInput<String> version;
    @Inject
    private ClientFactory factory;
    @Inject
    TemplateFactory templateFactory;
    @Inject
    ResourceFactory resourceFactory;
    @Inject
    private DependencyInstaller dependencyInstaller;
    Client client;
    Set<String> availableComponents;

    public UICommandMetadata getMetadata(UIContext context) {
        return Metadata.forCommand(CamelNewComponentsCommand.class).name("camel-new-component").category(Categories.create((String[])new String[]{CATEGORY})).description("Add new Camel components to the project.");
    }

    @Override
    public void initializeUI(UIBuilder builder) throws Exception {
        super.initializeUI(builder);
        this.initializeAvailableCamelComponents();
        this.named.setCompleter((UICompleter)new UICompleter<String>(){

            public Iterable<String> getCompletionProposals(UIContext context, InputComponent<?, String> input, String value) {
                ArrayList<String> filteredList = new ArrayList<String>(CamelNewComponentsCommand.this.availableComponents.size());
                for (String s : CamelNewComponentsCommand.this.availableComponents) {
                    if (CamelNewComponentsCommand.this.camelDepsInUse.contains(s)) continue;
                    filteredList.add(s);
                }
                ArrayList<String> noPrefixList = new ArrayList<String>(filteredList.size());
                for (String s : filteredList) {
                    noPrefixList.add(s.split("-")[1]);
                }
                ArrayList<String> componentsList = new ArrayList<String>(noPrefixList.size());
                for (String s : noPrefixList) {
                    if (!s.startsWith(value)) continue;
                    componentsList.add(s);
                }
                Collections.sort(componentsList);
                return componentsList;
            }
        });
        this.version.setCompleter((UICompleter)new UIVersionCompleter(this));
        this.named.addValidator(new UIValidator(){

            public void validate(UIValidationContext context) {
                if (CamelNewComponentsCommand.this.availableComponents == null) {
                    CamelNewComponentsCommand.this.availableComponents = CamelNewComponentsCommand.this.initializeAvailableCamelComponents();
                }
                if (!CamelNewComponentsCommand.this.availableComponents.contains("camel-" + context.getCurrentInputComponent().getValue())) {
                    context.addValidationError(context.getCurrentInputComponent(), "Selected Camel component is not available.");
                }
            }
        });
        builder.add(this.named).add(this.version);
    }

    public Result execute(UIExecutionContext context) throws Exception {
        String component = (String)this.named.getValue();
        component = "camel-" + component;
        String selectedVersion = (String)this.version.getValue();
        Project project = this.getSelectedProject((UIContextProvider)context);
        this.installMavenDependency(component, selectedVersion, project);
        CamelSupportedTechnologyEnum tech = null;
        try {
            tech = this.detectTechnology(project);
        }
        catch (IllegalStateException e) {
            return Results.fail((String)"Unable to identify project type.");
        }
        switch (tech) {
            case BLUEPRINT: {
                ResourcesFacet facet = (ResourcesFacet)this.getSelectedProject((UIContextProvider)context).getFacet(ResourcesFacet.class);
                String outputFilePath = "OSGI-INF" + File.separator + "blueprint" + File.separator + "components.xml";
                FileResource fileResource = facet.getResource(outputFilePath);
                Resource xml = this.resourceFactory.create((Object)((Object)((Object)this)).getClass().getResource("/templates/my_blueprint.ftl")).reify(URLResource.class);
                Template template = this.templateFactory.create(xml, FreemarkerTemplate.class);
                HashMap<String, String> templateContext = new HashMap<String, String>();
                String componentId = component.split("-")[1];
                templateContext.put("componentId", componentId);
                String componentClass = this.findComponentFQCN(component, selectedVersion);
                templateContext.put("componentClass", componentClass);
                UIPrompt prompt = context.getPrompt();
                if (!prompt.promptBoolean("File '" + outputFilePath + "' already exists. Do you want to overwrite it?")) {
                    return Results.fail((String)("File '" + outputFilePath + "' already exists."));
                }
                fileResource.createNewFile();
                fileResource.setContents(template.process(templateContext));
                break;
            }
            case SPRING: {
                ResourcesFacet facet = (ResourcesFacet)this.getSelectedProject((UIContextProvider)context).getFacet(ResourcesFacet.class);
                String outputFilePath = "META-INF" + File.separator + "spring" + File.separator + "components.xml";
                FileResource fileResource = facet.getResource(outputFilePath);
                Resource xml = this.resourceFactory.create((Object)((Object)((Object)this)).getClass().getResource("/templates/my_spring.ftl")).reify(URLResource.class);
                Template template = this.templateFactory.create(xml, FreemarkerTemplate.class);
                HashMap<String, String> templateContext = new HashMap<String, String>();
                String componentId = component.split("-")[1];
                templateContext.put("componentId", componentId);
                String componentClass = this.findComponentFQCN(component, selectedVersion);
                templateContext.put("componentClass", componentClass);
                UIPrompt prompt = context.getPrompt();
                if (!prompt.promptBoolean("File '" + outputFilePath + "' already exists. Do you want to overwrite it?")) {
                    return Results.fail((String)("File '" + outputFilePath + "' already exists."));
                }
                fileResource.createNewFile();
                fileResource.setContents(template.process(templateContext));
                break;
            }
        }
        return Results.success((String)(component + " component successfully installed!"));
    }

    private String findComponentFQCN(String component, String selectedVersion) {
        String result = null;
        InputStream stream = null;
        try {
            File tmp = File.createTempFile("camel-dep", "jar");
            URL url = new URL(String.format("https://repo1.maven.org/maven2/org/apache/camel/%s/%s/%s-%s.jar", component, selectedVersion, component, selectedVersion));
            FileUtils.copyURLToFile((URL)url, (File)tmp);
            ZipFile zipFile = new ZipFile(tmp);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().startsWith("META-INF/services/org/apache/camel/component/") || entry.isDirectory()) continue;
                stream = zipFile.getInputStream(entry);
                Properties prop = new Properties();
                prop.load(stream);
                result = prop.getProperty("class");
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to inspect added component", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception e) {}
            }
        }
        return result;
    }

    private void installMavenDependency(String component, String selectedVersion, Project project) {
        DependencyBuilder dependency = DependencyBuilder.create().setGroupId("org.apache.camel").setVersion(selectedVersion).setArtifactId(component);
        this.dependencyInstaller.install(project, (Dependency)dependency);
    }

    private synchronized Set<String> initializeAvailableCamelComponents() {
        if (this.availableComponents == null) {
            String camelComponentsListLocation = "https://raw.githubusercontent.com/fusesource/fuseide/master/core/plugins/org.fusesource.ide.camel.model/components/components-2.13.2.xml";
            LinkedHashSet<String> result = new LinkedHashSet<String>();
            String xmlString = null;
            this.client = this.factory.createClient();
            try {
                xmlString = (String)this.client.target(camelComponentsListLocation).request(new MediaType[]{MediaType.WILDCARD_TYPE}).get(String.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to fetch list of Camel components from: " + camelComponentsListLocation, e);
            }
            XMLDocument xml = new XMLDocument(xmlString);
            List connectors = xml.xpath("/connectors/connector/@id");
            for (String id : connectors) {
                result.add("camel-" + id);
            }
            this.availableComponents = Collections.unmodifiableSet(result);
        }
        return this.availableComponents;
    }

    private CamelSupportedTechnologyEnum detectTechnology(Project project) {
        if (this.probeForCDI(project)) {
            return CamelSupportedTechnologyEnum.JAVA;
        }
        if (this.probeForBlueprint(project)) {
            return CamelSupportedTechnologyEnum.BLUEPRINT;
        }
        if (this.probeForSpring(project)) {
            return CamelSupportedTechnologyEnum.SPRING;
        }
        throw new IllegalStateException("We couldn't identify Camel Project technology");
    }

    private boolean probeForSpring(Project project) {
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        FileResource resource = facet.getResource("META-INF" + File.separator + "spring");
        return resource.isDirectory();
    }

    private boolean probeForBlueprint(Project project) {
        ResourcesFacet facet = (ResourcesFacet)project.getFacet(ResourcesFacet.class);
        FileResource resource = facet.getResource("OSGI-INF");
        return resource.isDirectory();
    }

    private boolean probeForCDI(Project project) {
        final boolean[] matched = new boolean[]{false};
        ((JavaSourceFacet)project.getFacet(JavaSourceFacet.class)).visitJavaSources(new JavaResourceVisitor(){

            public void visit(VisitContext context, JavaResource javaResource) {
                try {
                    JavaClassSource source;
                    JavaSource javaType = (JavaSource)javaResource.getJavaType();
                    if (javaType.isClass() && ((source = (JavaClassSource)javaType).hasAnnotation(ContextName.class) || source.hasAnnotation(Uri.class))) {
                        matched[0] = true;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
        return matched[0];
    }
}

