/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.IOHelpers;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;

public class GitHelpers {
    public static String extractGitUrl(File basedir) throws IOException {
        String text;
        File gitConfig;
        if (basedir.exists() && basedir.isDirectory() && (gitConfig = new File(basedir, ".git/config")).isFile() && gitConfig.exists() && (text = IOHelpers.readFully(gitConfig)) != null) {
            return GitHelpers.extractGitUrl(text);
        }
        File parentFile = basedir.getParentFile();
        if (parentFile != null) {
            return GitHelpers.extractGitUrl(parentFile);
        }
        return null;
    }

    public static String extractGitUrl(String configText) {
        String remote = null;
        String lastUrl = null;
        String firstUrl = null;
        BufferedReader reader = new BufferedReader(new StringReader(configText));
        HashMap<String, String> remoteUrls = new HashMap<String, String>();
        while (true) {
            String[] parts;
            String trimmed;
            String line = null;
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (line == null) break;
            if (line.startsWith("[remote ")) {
                String[] parts2 = line.split("\"");
                if (parts2.length <= 1) continue;
                remote = parts2[1];
                continue;
            }
            if (line.startsWith("[")) {
                remote = null;
                continue;
            }
            if (remote == null || line.length() <= 0 || !Character.isWhitespace(line.charAt(0)) || !(trimmed = line.trim()).startsWith("url ") || (parts = trimmed.split("=", 2)).length <= 1) continue;
            lastUrl = parts[1].trim();
            if (firstUrl == null) {
                firstUrl = lastUrl;
            }
            remoteUrls.put(remote, lastUrl);
        }
        String answer = null;
        if (remoteUrls.size() == 1) {
            return lastUrl;
        }
        if (remoteUrls.size() > 1 && (answer = (String)remoteUrls.get("origin")) == null) {
            answer = firstUrl;
        }
        return answer;
    }
}

