/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import io.fabric8.utils.Closeables;
import io.fabric8.utils.IOHelpers;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;

public final class Files {
    private static final ThreadLocal<LinkedHashSet<URL>> ACTIVE_DOWNLOADS = new ThreadLocal();
    private static final AtomicLong lastTmpFileId = new AtomicLong(System.currentTimeMillis());
    private static final int BUFFER_SIZE = 8192;
    private static boolean windowsOs = Files.initWindowsOs();

    private Files() {
    }

    private static boolean initWindowsOs() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        return osName.contains("windows");
    }

    public static boolean isFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean isDirectory(File file) {
        return file != null && file.exists() && file.isDirectory();
    }

    public static String normalizePath(String path) {
        if (path == null) {
            return null;
        }
        if (Files.isWindows()) {
            return Files.normalizePath(path, '/', '\\');
        }
        return Files.normalizePath(path, '\\', '/');
    }

    public static String normalizePath(String path, char from, char to) {
        return path.replace(from, to);
    }

    public static boolean isWindows() {
        return windowsOs;
    }

    public static String stripLeadingSeparator(String name) {
        if (name == null) {
            return null;
        }
        while (name.startsWith("/") || name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        return name;
    }

    public static String getFileName(String path) {
        if (path != null) {
            return new File(path).getName();
        }
        return null;
    }

    public static String getFileExtension(String path) {
        String answer;
        int idx;
        String fileName = Files.getFileName(path);
        if (fileName != null && (idx = fileName.lastIndexOf(46)) > 1 && (answer = fileName.substring(idx + 1)).length() > 0) {
            return answer;
        }
        return null;
    }

    public static String getFileExtension(File file) {
        return Files.getFileExtension(file.getName());
    }

    public static File createTempFile(String path) throws IOException {
        File dataDir = new File(path);
        File tmpDir = new File(dataDir, "tmp");
        if (!tmpDir.exists() && !tmpDir.mkdirs()) {
            throw new IOException("Failed to create tmp dir:" + tmpDir.getAbsolutePath());
        }
        return File.createTempFile(String.valueOf(lastTmpFileId.incrementAndGet()), ".tmp", tmpDir);
    }

    public static String toString(File file, Charset charset) throws IOException {
        byte[] bytes = Files.readBytes(file);
        if (charset != null) {
            return new String(bytes, charset);
        }
        return new String(bytes);
    }

    public static String toString(InputStream inputStream) throws IOException {
        return Files.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, Charset charset) throws IOException {
        byte[] bytes = Files.readBytes(inputStream);
        if (charset != null) {
            return new String(bytes, charset);
        }
        return new String(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(File file) throws IOException {
        ArrayList<String> answer = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                answer.add(line);
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeLines(File file, List<String> lines) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));){
            for (String line : lines) {
                writer.println(line);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(File file) throws IOException {
        byte[] byArray;
        FileInputStream fis = null;
        ByteArrayOutputStream bos = null;
        if (file == null) {
            throw new FileNotFoundException("No file specified");
        }
        try {
            int remaining;
            fis = new FileInputStream(file);
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((remaining = fis.read(buffer)) > 0) {
                bos.write(buffer, 0, remaining);
            }
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(fis);
            Closeables.closeQuietly(bos);
            throw throwable;
        }
        Closeables.closeQuietly(fis);
        Closeables.closeQuietly(bos);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream bos = null;
        if (in == null) {
            throw new FileNotFoundException("No InputStream specified");
        }
        try {
            int remaining;
            bos = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            while ((remaining = in.read(buffer)) > 0) {
                bos.write(buffer, 0, remaining);
            }
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        finally {
            Closeables.closeQuietly(in);
            Closeables.closeQuietly(bos);
        }
    }

    public static String toString(File file) throws IOException {
        return Files.toString(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String content, Charset charset) throws IOException {
        FileOutputStream fos = null;
        OutputStreamWriter writer = null;
        try {
            if (file == null) {
                throw new FileNotFoundException("No file specified.");
            }
            if (!(file.exists() || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
                throw new FileNotFoundException("Could not find or create file:" + file.getName());
            }
            fos = new FileOutputStream(file);
            writer = new OutputStreamWriter((OutputStream)fos, charset);
            writer.write(content, 0, content.length());
            writer.flush();
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(fos);
            Closeables.closeQuietly(writer);
            throw throwable;
        }
        Closeables.closeQuietly(fos);
        Closeables.closeQuietly(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, byte[] content) throws IOException {
        FileOutputStream fos = null;
        try {
            if (file == null) {
                throw new FileNotFoundException("No file specified.");
            }
            if (!(file.exists() || file.getParentFile().exists() || file.getParentFile().mkdirs())) {
                throw new FileNotFoundException("Could not find or create file:" + file.getName());
            }
            fos = new FileOutputStream(file);
            fos.write(content);
        }
        catch (Throwable throwable) {
            Closeables.closeQuietly(fos);
            throw throwable;
        }
        Closeables.closeQuietly(fos);
    }

    public static void copy(File source, File target) throws IOException {
        if (!source.exists()) {
            throw new FileNotFoundException("Source file not found:" + source.getAbsolutePath());
        }
        if (!(target.exists() || target.getParentFile().exists() || target.getParentFile().mkdirs())) {
            throw new IOException("Can't create target directory:" + target.getParentFile().getAbsolutePath());
        }
        FileInputStream is = new FileInputStream(source);
        FileOutputStream os = new FileOutputStream(target);
        Files.copy(is, os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream os) throws IOException {
        try {
            int len;
            byte[] buffer = new byte[8192];
            while ((len = is.read(buffer)) > 0) {
                os.write(buffer, 0, len);
            }
        }
        finally {
            Closeables.closeQuietly(is);
            Closeables.closeQuietly(os);
        }
    }

    public static String getRelativePath(File rootDir, File file) throws IOException {
        String rootPath = rootDir.getCanonicalPath();
        String fullPath = file.getCanonicalPath();
        if (fullPath.startsWith(rootPath)) {
            return fullPath.substring(rootPath.length());
        }
        return fullPath;
    }

    public static void assertExists(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(file + " does not exist");
        }
    }

    public static void assertFileExists(File file) {
        Files.assertExists(file);
        if (!file.isFile()) {
            throw new IllegalArgumentException(file + " is not a file!");
        }
    }

    public static void assertDirectoryExists(File file) {
        Files.assertExists(file);
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(file + " is not a directory!");
        }
    }

    public static int recursiveDelete(File file) {
        File[] files;
        int answer = 0;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File child : files) {
                answer += Files.recursiveDelete(child);
            }
        }
        if (file.delete()) {
            ++answer;
        }
        return answer;
    }

    public static void recursiveDelete(File file, FileFilter filter) {
        if (filter == null || filter.accept(file)) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (File child : files) {
                        Files.recursiveDelete(child, filter);
                    }
                }
                if ((files = file.listFiles()) == null || files.length == 0) {
                    file.delete();
                }
            } else {
                file.delete();
            }
        }
    }

    public static File urlToFile(String url, String tempFilePrefix, String tempFilePostfix) throws IOException {
        File file = new File(url);
        if (file.exists()) {
            return file;
        }
        return Files.urlToFile(new URL(url), tempFilePrefix, tempFilePostfix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File urlToFile(URL url, String tempFilePrefix, String tempFilePostfix) throws IOException {
        LinkedHashSet<URL> original = ACTIVE_DOWNLOADS.get();
        LinkedHashSet<URL> downloads = original;
        if (downloads == null) {
            downloads = new LinkedHashSet();
            ACTIVE_DOWNLOADS.set(downloads);
        }
        try {
            File file;
            if (downloads.contains(url)) {
                throw new DownloadCycleException("Download cycle detected: " + downloads);
            }
            downloads.add(url);
            try {
                String fileName = url.getFile();
                File file2 = new File(fileName);
                if (!file2.exists()) {
                    file2 = File.createTempFile(tempFilePrefix, tempFilePostfix);
                    InputStream in = url.openStream();
                    IOHelpers.writeTo(file2, in);
                }
                file = file2;
            }
            catch (Throwable throwable) {
                downloads.remove(url);
                throw throwable;
            }
            downloads.remove(url);
            return file;
        }
        finally {
            if (original == null) {
                ACTIVE_DOWNLOADS.remove();
            }
        }
    }

    public static String guessMediaType(File fileName) {
        return Files.guessMediaType(fileName.getName());
    }

    public static String guessMediaType(String fileName) {
        if (fileName.endsWith(".xml")) {
            return "application/xml";
        }
        if (fileName.endsWith(".wadl")) {
            return "application/wadl+xml";
        }
        if (fileName.endsWith(".wsdl")) {
            return "application/wsdl+xml";
        }
        if (fileName.endsWith(".xsd")) {
            return "application/xsd+xml";
        }
        if (fileName.endsWith(".json")) {
            return "application/json";
        }
        if (fileName.endsWith(".html") || fileName.endsWith(".htm")) {
            return "application/html";
        }
        if (fileName.endsWith(".properties")) {
            return "text/x-java-properties";
        }
        if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (fileName.endsWith(".png")) {
            return "image/png";
        }
        if (fileName.endsWith(".gif")) {
            return "image/gif";
        }
        if (fileName.endsWith(".svg")) {
            return "image/svg+xml";
        }
        return "text/plain";
    }

    public static class DownloadCycleException
    extends IOException {
        public DownloadCycleException(String s) {
            super(s);
        }
    }
}

