/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.internal;

import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import io.fabric8.spring.boot.AbstractServiceRegistar;
import java.util.ArrayList;
import java.util.Map;
import org.springframework.context.annotation.Configuration;

@Configuration
public class InternalServiceRegistar
extends AbstractServiceRegistar {
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String SERVICE_PORT = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";

    @Override
    public Service getService(String serviceName) {
        Map<String, String> env = System.getenv();
        String prefix = serviceName.toUpperCase();
        String serviceHost = env.get(prefix + HOST_SUFFIX);
        String defaultPortName = prefix + SERVICE_PORT;
        String namedPortPrefix = defaultPortName + "_";
        ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(namedPortPrefix)) continue;
            String name = key.substring(namedPortPrefix.length());
            String portValue = entry.getValue();
            String protocolValue = env.get(key + "_" + PROTO_SUFFIX);
            servicePorts.add(((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(name.toLowerCase())).withPort(Integer.valueOf(Integer.parseInt(portValue)))).withProtocol(protocolValue != null ? protocolValue : "TCP")).build());
        }
        if (servicePorts.isEmpty()) {
            String portValue = env.get(defaultPortName);
            String protocolValue = env.get(defaultPortName + PROTO_SUFFIX);
            servicePorts.add(((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withPort(Integer.valueOf(Integer.parseInt(portValue)))).withProtocol(protocolValue != null ? protocolValue : "TCP")).build());
        }
        return ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(serviceName)).endMetadata()).withNewSpec().withClusterIP(serviceHost)).withPorts(servicePorts)).endSpec()).build();
    }
}

