/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.converters;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Component
public class ServiceConverter
implements GenericConverter {
    @Autowired
    private KubernetesClient kubernetesClient;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return new LinkedHashSet<GenericConverter.ConvertiblePair>(Arrays.asList(new GenericConverter.ConvertiblePair(Service.class, String.class), new GenericConverter.ConvertiblePair(Service.class, URL.class)));
    }

    public Object convert(Object o, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Service source = (Service)o;
        String serviceName = KubernetesHelper.getName((HasMetadata)source);
        String serviceNamespace = KubernetesHelper.getNamespace((HasMetadata)source);
        String serviceProtocol = this.getProtocolOfService(source);
        Boolean serviceExternal = this.isServiceExternal(source);
        serviceNamespace = serviceNamespace != null ? serviceNamespace : KubernetesHelper.defaultNamespace();
        String str = KubernetesHelper.getServiceURL((KubernetesClient)this.kubernetesClient, (String)serviceName, (String)serviceNamespace, (String)serviceProtocol, (boolean)serviceExternal);
        try {
            if (String.class.equals((Object)targetType.getObjectType())) {
                return str;
            }
            if (URL.class.equals((Object)targetType.getObjectType())) {
                return new URL(str);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to convert from: " + sourceType.getObjectType() + " to: " + targetType.getObjectType());
        }
        throw new IllegalStateException("Invalid target type: " + targetType.getObjectType());
    }

    private String getProtocolOfService(Service service) {
        Object protocolProperty;
        String protocol = "tcp";
        if (service.getAdditionalProperties().containsKey("PROTOCOL") && (protocolProperty = service.getAdditionalProperties().get("PROTOCOL")) instanceof String) {
            protocol = (String)protocolProperty;
        }
        return protocol;
    }

    private Boolean isServiceExternal(Service service) {
        Object externalProperty;
        Boolean external = false;
        if (service.getAdditionalProperties().containsKey("EXTERNAL") && (externalProperty = service.getAdditionalProperties().get("EXTERNAL")) instanceof Boolean) {
            external = (Boolean)externalProperty;
        }
        return external;
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public void setKubernetesClient(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }
}

