/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.converters;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.openshift.api.model.Route;
import io.fabric8.openshift.api.model.RouteList;
import io.fabric8.openshift.client.OpenShiftClient;
import io.fabric8.utils.KubernetesServices;
import io.fabric8.utils.Strings;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

@Component
public class ServiceConverter
implements GenericConverter {
    @Autowired
    private KubernetesClient kubernetesClient;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return new LinkedHashSet<GenericConverter.ConvertiblePair>(Arrays.asList(new GenericConverter.ConvertiblePair(Service.class, String.class), new GenericConverter.ConvertiblePair(Service.class, URL.class)));
    }

    public Object convert(Object o, TypeDescriptor sourceType, TypeDescriptor targetType) {
        Service source = (Service)o;
        String serviceProtocol = this.getProtocolOfService(source);
        String servicePort = this.getPortOfService(source);
        String str = this.getServiceURL(this.kubernetesClient, source, serviceProtocol, servicePort);
        try {
            if (String.class.equals((Object)targetType.getObjectType())) {
                return str;
            }
            if (URL.class.equals((Object)targetType.getObjectType())) {
                return new URL(str);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to convert from: " + sourceType.getObjectType() + " to: " + targetType.getObjectType());
        }
        throw new IllegalStateException("Invalid target type: " + targetType.getObjectType());
    }

    private String getProtocolOfService(Service service) {
        Object protocolProperty;
        String protocol = "tcp";
        if (service.getAdditionalProperties().containsKey("PROTOCOL") && (protocolProperty = service.getAdditionalProperties().get("PROTOCOL")) instanceof String) {
            protocol = (String)protocolProperty;
        }
        return protocol;
    }

    private String getPortOfService(Service service) {
        Object portProperty;
        String port = null;
        if (service.getAdditionalProperties().containsKey("PORT") && (portProperty = service.getAdditionalProperties().get("PORT")) instanceof String) {
            port = (String)portProperty;
        }
        return port;
    }

    private Boolean isServiceExternal(Service service) {
        Object externalProperty;
        Boolean external = false;
        if (service.getAdditionalProperties().containsKey("EXTERNAL") && (externalProperty = service.getAdditionalProperties().get("EXTERNAL")) instanceof Boolean) {
            external = (Boolean)externalProperty;
        }
        return external;
    }

    public String getServiceURL(KubernetesClient client, Service srv, String serviceProtocol, String servicePortName) {
        ServicePort port;
        String serviceProto;
        String serviceName = KubernetesHelper.getName((HasMetadata)srv);
        String string = serviceProto = serviceProtocol != null ? serviceProtocol : KubernetesServices.serviceToProtocol((String)serviceName, (String)servicePortName);
        if (Strings.isNullOrBlank((String)servicePortName) && KubernetesHelper.isOpenShift((KubernetesClient)client)) {
            OpenShiftClient openShiftClient = (OpenShiftClient)client.adapt(OpenShiftClient.class);
            RouteList routeList = (RouteList)openShiftClient.routes().list();
            for (Route route : routeList.getItems()) {
                if (!route.getSpec().getTo().getName().equals(serviceName)) continue;
                return (serviceProto + "://" + route.getSpec().getHost()).toLowerCase();
            }
        }
        if ((port = KubernetesHelper.findServicePortByName((Service)srv, (String)servicePortName)) == null) {
            throw new RuntimeException("Couldn't find port: " + servicePortName + " for service:" + serviceName);
        }
        String clusterIP = srv.getSpec().getClusterIP();
        if ("None".equals(clusterIP)) {
            throw new IllegalStateException("Service " + serviceName + " is head-less. Search for endpoints instead.");
        }
        return (serviceProto + "://" + clusterIP + ":" + port.getPort()).toLowerCase();
    }

    public KubernetesClient getKubernetesClient() {
        return this.kubernetesClient;
    }

    public void setKubernetesClient(KubernetesClient kubernetesClient) {
        this.kubernetesClient = kubernetesClient;
    }
}

