/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.condition;

import io.fabric8.utils.Strings;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

public class OnInsideKubernetesCondition
extends SpringBootCondition {
    private final String HOSTNAME = "HOSTNAME";
    private final String KUBERNETES_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    private final String KUBERNETES_SERVICE_PORT = "KUBERNETES_SERVICE_PORT";
    private final String[] REQUIRED_ENV_VARIABLES = new String[]{"HOSTNAME", "KUBERNETES_SERVICE_HOST", "KUBERNETES_SERVICE_PORT"};

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        for (String variable : this.REQUIRED_ENV_VARIABLES) {
            if (!Strings.isNullOrBlank((String)System.getenv().get(variable))) continue;
            return ConditionOutcome.noMatch((String)("Environment variable " + variable + " not found."));
        }
        return ConditionOutcome.match();
    }
}

