/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.spring.boot.internal;

import io.fabric8.annotations.ServiceName;
import io.fabric8.kubernetes.api.model.Service;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.type.AnnotationMetadata;

public class InternalServiceRegistar
implements ImportBeanDefinitionRegistrar {
    private static final String SERVICE = "service";
    private static final String SERVICE_HOST_REGEX = "(?<service>[A-Z_]+)_SERVICE_HOST";
    private static final Pattern SERVICE_HOST_PATTERN = Pattern.compile("(?<service>[A-Z_]+)_SERVICE_HOST");
    private static final String HOST_SUFFIX = "_SERVICE_HOST";
    private static final String PORT_SUFFIX = "_SERVICE_PORT";
    private static final String PROTO_SUFFIX = "_TCP_PROTO";

    public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            String service;
            String key = entry.getKey();
            Matcher matcher = SERVICE_HOST_PATTERN.matcher(key);
            if (!matcher.matches() || !this.areEnvVariablesAvailable(service = matcher.group(SERVICE), env)) continue;
            RootBeanDefinition beanDefinition = new RootBeanDefinition(Service.class);
            String serviceHost = env.get(service + HOST_SUFFIX);
            String port = env.get(service + PORT_SUFFIX);
            String protocol = env.get(service + PORT_SUFFIX + "_" + port + PROTO_SUFFIX);
            beanDefinition.addQualifier(new AutowireCandidateQualifier(ServiceName.class, (Object)service));
            beanDefinition.getPropertyValues().addPropertyValue("id", (Object)service);
            beanDefinition.getPropertyValues().addPropertyValue("port", (Object)port);
            beanDefinition.getPropertyValues().addPropertyValue("portalIP", (Object)serviceHost);
            beanDefinition.getPropertyValues().addPropertyValue("protocol", (Object)protocol);
            registry.registerBeanDefinition(service + "-service-bean", (BeanDefinition)beanDefinition);
        }
    }

    private boolean areEnvVariablesAvailable(String service, Map<String, String> env) {
        return env.containsKey(service + HOST_SUFFIX) && env.containsKey(service + PORT_SUFFIX) && env.containsKey(service + PORT_SUFFIX);
    }
}

