/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.selenium;

import com.google.common.base.Function;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.selenium.FormFacade;
import io.fabric8.selenium.LogSupport;
import io.fabric8.utils.Millis;
import io.fabric8.utils.Strings;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

public class WebDriverFacade
extends LogSupport {
    private final WebDriver driver;
    private final KubernetesClient client;
    private final String namespace;
    private long defaultTimeoutInSeconds = 60L;

    public WebDriverFacade(WebDriver driver, KubernetesClient client, String namespace) {
        super(driver);
        this.driver = driver;
        this.client = client;
        this.namespace = namespace;
    }

    @Override
    public WebDriverFacade getFacade() {
        return this;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public KubernetesClient getClient() {
        return this.client;
    }

    public String getServiceUrl(String serviceName) {
        String url = KubernetesHelper.getServiceURL((KubernetesClient)this.client, (String)serviceName, (String)this.namespace, (String)"http", (boolean)true);
        Assert.assertNotNull((String)("No external Service URL could be found for namespace: " + this.namespace + " and name: " + serviceName), (Object)url);
        Assert.assertTrue((String)("No external Service URL could be found for namespace: " + this.namespace + " and name: " + serviceName), (boolean)Strings.isNotBlank((String)url));
        this.logInfo("Service " + serviceName + " in namespace: " + this.namespace + " URL = " + url);
        return url;
    }

    public String navigateToService(String serviceName) {
        String url = this.getServiceUrl(serviceName);
        this.getDriver().navigate().to(url);
        return url;
    }

    public WebElement findOptionalElement(By by) {
        try {
            return this.getDriver().findElement(by);
        }
        catch (NoSuchElementException e) {
            return null;
        }
        catch (Throwable e) {
            this.logError("Failed to find " + by, e);
            return null;
        }
    }

    public WebElement findOptionalElement(WebElement element, By by) {
        try {
            return element.findElement(by);
        }
        catch (NoSuchElementException e) {
            return null;
        }
        catch (Throwable e) {
            this.logError("Failed to find " + by, e);
            return null;
        }
    }

    public WebElement clearAndSendKeys(By by, String text) {
        WebElement field = this.findOptionalElement(by);
        if (field != null) {
            field.clear();
            field.sendKeys(new CharSequence[]{text});
        }
        return field;
    }

    public FormFacade form() {
        return new FormFacade(this);
    }

    public boolean until(ExpectedCondition<Boolean> condition) {
        return this.until(condition.toString(), this.defaultTimeoutInSeconds, condition);
    }

    public boolean until(String message, ExpectedCondition<Boolean> condition) {
        return this.until(message, this.defaultTimeoutInSeconds, condition);
    }

    public boolean until(String message, long timeoutInSeconds, ExpectedCondition<Boolean> condition) {
        return (Boolean)new WebDriverWait(this.getDriver(), timeoutInSeconds).withMessage(message).until(condition);
    }

    public boolean untilLinkClicked(By by) {
        return this.untilLinkClicked(this.defaultTimeoutInSeconds, by);
    }

    public boolean untilSelectedByVisibleText(By by, String value) {
        return this.untilSelectedByVisibleText(this.defaultTimeoutInSeconds, by, value);
    }

    public boolean untilSelectedByVisibleText(long timeoutInSeconds, final By by, final String value) {
        String message = "select " + by + " with value: " + value;
        return (Boolean)new WebDriverWait(this.getDriver(), timeoutInSeconds).withMessage(message).until((Function)new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver webDriver) {
                WebElement element = WebDriverFacade.this.findOptionalElement(by);
                if (element != null && element.isEnabled()) {
                    Select select = new Select(element);
                    try {
                        select.selectByVisibleText(value);
                        WebDriverFacade.this.logInfo("" + by + " select " + select + " selected value: " + value);
                        return true;
                    }
                    catch (NoSuchElementException e) {
                        WebDriverFacade.this.logWait("" + by + " select " + select + " does not yet have value: " + value);
                        return false;
                    }
                }
                WebDriverFacade.this.logWait("" + by + " not enabled");
                return false;
            }
        });
    }

    public boolean untilIsDisplayed(By firstBy, By secondBy) {
        return this.untilIsDisplayed(this.defaultTimeoutInSeconds, firstBy, secondBy);
    }

    public boolean untilIsDisplayed(long timeoutInSeconds, final By firstBy, final By secondBy) {
        String message = "" + firstBy + " then  " + secondBy + " is displayed";
        return this.until(message, timeoutInSeconds, new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement element = WebDriverFacade.this.findOptionalElement(firstBy);
                if (element == null) {
                    WebDriverFacade.this.logWait("" + firstBy + "");
                    return false;
                }
                WebElement link = WebDriverFacade.this.findOptionalElement(element, secondBy);
                if (link != null && link.isDisplayed()) {
                    WebDriverFacade.this.logInfo("" + firstBy + " then " + secondBy + " displayed");
                    return true;
                }
                WebDriverFacade.this.logWait("" + firstBy + " then " + secondBy + " displayed");
                return false;
            }
        });
    }

    public boolean untilElementPredicate(By by, Function<WebElement, Boolean> elementPredicate) {
        return this.untilElementPredicate(this.defaultTimeoutInSeconds, by, elementPredicate);
    }

    public boolean untilElementPredicate(long timeoutInSeconds, final By by, final Function<WebElement, Boolean> elementPredicate) {
        String message = "" + by + " matches  " + elementPredicate;
        return this.until(message, timeoutInSeconds, new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement element = WebDriverFacade.this.findOptionalElement(by);
                if (element == null) {
                    WebDriverFacade.this.logWait("" + by + "");
                    return false;
                }
                Boolean value = (Boolean)elementPredicate.apply((Object)element);
                if (value != null && value.booleanValue()) {
                    WebDriverFacade.this.logInfo("" + by + " matches  " + elementPredicate + "");
                    return true;
                }
                WebDriverFacade.this.logWait("" + by + " matches  " + elementPredicate + "");
                return false;
            }
        });
    }

    public boolean untilIsDisplayed(By by) {
        return this.untilIsDisplayed(this.defaultTimeoutInSeconds, by);
    }

    public boolean untilIsDisplayed(long timeoutInSeconds, By by) {
        return this.untilElementPredicate(timeoutInSeconds, by, new Function<WebElement, Boolean>(){

            public String toString() {
                return "element.isDisplayed()";
            }

            public Boolean apply(WebElement element) {
                return element.isDisplayed();
            }
        });
    }

    public boolean untilIsEnabled(By by) {
        return this.untilIsEnabled(this.defaultTimeoutInSeconds, by);
    }

    public boolean untilIsEnabled(long timeoutInSeconds, By by) {
        return this.untilElementPredicate(timeoutInSeconds, by, new Function<WebElement, Boolean>(){

            public String toString() {
                return "element.isEnabled()";
            }

            public Boolean apply(WebElement element) {
                return element.isEnabled();
            }
        });
    }

    public boolean untilLinkClicked(long timeoutInSeconds, final By by) {
        String message = "click link " + by;
        return this.until(message, timeoutInSeconds, new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                WebElement link = WebDriverFacade.this.findOptionalElement(by);
                if (link != null) {
                    WebDriverFacade.this.logInfo("Clicking link: " + by + "");
                    link.click();
                    WebDriverFacade.this.logInfo("Clicked link: " + by + " now");
                    return true;
                }
                WebDriverFacade.this.logInfo("Not found link " + by + "");
                return false;
            }
        });
    }

    public void untilOneOf(final By ... bys) {
        final List<By> byList = Arrays.asList(bys);
        String message = "One of these is available: " + byList;
        this.until(message, this.defaultTimeoutInSeconds, new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                for (By by : bys) {
                    WebElement element = WebDriverFacade.this.findOptionalElement(by);
                    if (element == null || !element.isDisplayed() || !element.isEnabled()) continue;
                    WebDriverFacade.this.logInfo("Found " + element + " for " + by + "");
                    return true;
                }
                WebDriverFacade.this.logInfo("Still not found any of " + byList + "");
                return false;
            }
        });
    }

    public void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean currentUrlStartsWith(String expectedUrl) {
        boolean answer;
        String currentUrl = this.getDriver().getCurrentUrl();
        boolean bl = answer = currentUrl != null && currentUrl.startsWith(expectedUrl);
        if (!answer) {
            this.logWarn("Current URL `" + currentUrl + "` does not start with `" + expectedUrl + "`");
        }
        return answer;
    }

    public void assertCurrentUrlStartsWith(String expectedUrl) {
        boolean answer;
        String currentUrl = this.getDriver().getCurrentUrl();
        boolean bl = answer = currentUrl != null && currentUrl.startsWith(expectedUrl);
        if (!answer) {
            Assert.fail((String)("Current URL `" + currentUrl + "` does not start with `" + expectedUrl + "`"));
        }
    }

    public void untilLinkClickedLoop(By by, String expectedUrl) {
        for (int i = 0; i < 10; ++i) {
            this.untilLinkClicked(by);
            this.sleep(Millis.seconds((int)10));
            if (this.currentUrlStartsWith(expectedUrl)) break;
            this.logWarn("lets try re-clicking link: " + by);
        }
        this.assertCurrentUrlStartsWith(expectedUrl);
    }

    public long getDefaultTimeoutInSeconds() {
        return this.defaultTimeoutInSeconds;
    }

    public void setDefaultTimeoutInSeconds(long defaultTimeoutInSeconds) {
        this.defaultTimeoutInSeconds = defaultTimeoutInSeconds;
    }
}

