/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.forge;

import io.fabric8.forge.NewProjectFormData;
import io.fabric8.selenium.ConsoleTests;
import io.fabric8.selenium.PageSupport;
import io.fabric8.selenium.WebDriverFacade;
import io.fabric8.utils.Millis;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ProjectsPage
extends PageSupport {
    private final By signInBy = By.linkText((String)"Sign In");
    private final By createProjectBy = By.partialLinkText((String)"Create Project");
    private final By projectsLinkBy = By.linkText((String)"Projects");
    private final WebDriverFacade driverFacade;
    private final String namespace;
    private String startUrl;
    private String buildConfigsUrl;

    public ProjectsPage(WebDriverFacade facade, String namespace) {
        super(facade);
        this.driverFacade = facade;
        this.namespace = namespace;
        ConsoleTests.waitUntilLoggedIn(facade, namespace);
        this.startUrl = this.getDriver().getCurrentUrl();
        this.buildConfigsUrl = this.relativeUrl(this.startUrl, "/kubernetes", "/kubernetes/buildConfigs");
    }

    public void goToProjectsPage() {
        WebDriverFacade facade = this.getFacade();
        WebDriver driver = this.getDriver();
        facade.untilLinkClickedLoop(this.projectsLinkBy, this.buildConfigsUrl);
        facade.untilOneOf(this.signInBy, this.createProjectBy);
        WebElement signIn = facade.findOptionalElement(this.signInBy);
        if (signIn != null && signIn.isDisplayed()) {
            this.logInfo("Waiting for signin button to be clicked");
            facade.untilLinkClicked(this.signInBy);
            this.signIntoGogs();
        } else {
            this.logInfo("Sign in button not present");
        }
        this.logWait("button: " + this.createProjectBy + "");
        facade.untilIsEnabled(this.createProjectBy);
    }

    public void createProject(NewProjectFormData form) {
        this.goToProjectsPage();
        WebDriverFacade facade = this.getFacade();
        WebDriver driver = this.getDriver();
        facade.untilLinkClicked(this.createProjectBy);
        By nextButton = By.xpath((String)"//button[@ng-click='execute()']");
        facade.setDefaultTimeoutInSeconds(180L);
        String named = form.getNamed();
        facade.form().clearAndSendKeys(By.xpath((String)"//input[@ng-model='entity.named']"), named).submitButton(nextButton).submit();
        facade.form().completeComboBox(By.xpath((String)"//label[text() = 'Archetype']/following::input[@type='text']"), form.getArchetypeFilter()).submitButton(nextButton).submit();
        this.untilNextWizardPage(facade, nextButton);
        facade.form().submitButton(nextButton).submit();
        this.untilNextWizardPage(facade, nextButton);
        facade.form().completeComboBox(By.xpath((String)"//label[text() = 'Flow']/following::input[@type='text']"), form.getJenkinsFileFilter()).submitButton(nextButton).submit();
        facade.untilIsDisplayed(By.xpath((String)"//a[@href='/forge/repos' and text()='Done']"));
        this.logInfo("Created project: " + named);
        this.goToProjectsPage();
        facade.untilIsDisplayed(By.partialLinkText((String)named));
    }

    protected void untilNextWizardPage(WebDriverFacade facade, By nextButton) {
        facade.sleep(Millis.seconds((int)5));
        facade.untilIsEnabled(nextButton);
    }

    public By getCreateProjectBy() {
        return this.createProjectBy;
    }

    public By getSignInBy() {
        return this.signInBy;
    }

    protected String relativeUrl(String url, String trimPath, String newPath) {
        int idx = url.indexOf(trimPath);
        if (idx < 0) {
            Assert.fail((String)("The URL `" + url + "` does not include path `" + trimPath + "`"));
        }
        return url.substring(0, idx) + newPath;
    }

    protected void signIntoGogs() {
        this.getFacade().form().clearAndSendKeys(By.id((String)"gitUsername"), "gogsadmin").clearAndSendKeys(By.id((String)"gitPassword"), "RedHat$1").clearAndSendKeys(By.id((String)"gitEmail"), "james.strachan@gmail.com").submitButton(By.xpath((String)"//button[@ng-click='doLogin()']")).submit();
    }
}

