/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.selenium;

import io.fabric8.selenium.PageSupport;
import io.fabric8.selenium.WebDriverFacade;
import io.fabric8.selenium.inputs.ComboCompleteInputValue;
import io.fabric8.selenium.inputs.InputValue;
import io.fabric8.utils.Millis;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;

public class FormFacade
extends PageSupport {
    private List<InputValue> inputValues = new ArrayList<InputValue>();
    private By submitBy;

    public FormFacade(WebDriverFacade facade) {
        super(facade);
    }

    public FormFacade clearAndSendKeys(By by, String value) {
        this.inputValues.add(new InputValue(this.getFacade(), by, value));
        return this;
    }

    public FormFacade completeComboBox(By by, String value) {
        this.inputValues.add(new ComboCompleteInputValue(this.getFacade(), by, value));
        return this;
    }

    public FormFacade submitButton(By submitBy) {
        this.submitBy = submitBy;
        return this;
    }

    public void submit() {
        this.getFacade().until("Form inputs: " + this.inputValues, new ExpectedCondition<Boolean>(){

            public Boolean apply(WebDriver driver) {
                FormFacade.this.logWait("" + FormFacade.this.inputValues + " on " + driver.getCurrentUrl());
                WebElement submitElement = null;
                for (InputValue inputValue : FormFacade.this.inputValues) {
                    submitElement = inputValue.doInput();
                    if (submitElement != null) continue;
                    FormFacade.this.logInfo("Missing " + inputValue + "");
                    return false;
                }
                if (FormFacade.this.submitBy == null && submitElement == null) {
                    Assert.fail((String)"No input fields submitted yet");
                    return false;
                }
                FormFacade.this.getFacade().sleep(Millis.seconds((int)5));
                if (FormFacade.this.submitBy != null) {
                    FormFacade.this.getFacade().untilIsEnabled(FormFacade.this.submitBy);
                    submitElement = FormFacade.this.getFacade().findOptionalElement(FormFacade.this.submitBy);
                    if (submitElement == null) {
                        FormFacade.this.logWarn("Could not find submit button " + FormFacade.this.submitBy + "");
                        return false;
                    }
                    if (!submitElement.isDisplayed() || !submitElement.isEnabled()) {
                        FormFacade.this.logWarn("Submit button " + FormFacade.this.submitBy + " not enabled and visible");
                        return false;
                    }
                    FormFacade.this.logInfo("Submitting form: " + FormFacade.this.inputValues + " on " + submitElement + "");
                    submitElement.click();
                } else {
                    FormFacade.this.logInfo("Submitting form: " + FormFacade.this.inputValues + " on " + submitElement + "");
                    submitElement.submit();
                }
                return true;
            }
        });
    }
}

