/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.project.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniFileUtils {
    private static final transient Logger LOG = LoggerFactory.getLogger(IniFileUtils.class);

    public static Map<String, Properties> parseIniFile(File file) throws IOException {
        HashMap<String, Properties> answer = new HashMap<String, Properties>();
        String section = null;
        Properties properties = new Properties();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                if (line.startsWith("[")) {
                    if (!(line = line.trim()).endsWith("]")) {
                        LOG.warn("Invalid section header in file: " + file + ". Line: " + line);
                        continue;
                    }
                    section = line.substring(1, line.length() - 1);
                    properties = (Properties)answer.get(section);
                    if (properties != null) continue;
                    properties = new Properties();
                    answer.put(section, properties);
                    continue;
                }
                String[] parts = line.split("=", 2);
                if (parts == null && parts.length != 2) {
                    LOG.warn("Invalid property in section: " + section + " file: " + file + ". Line: " + line);
                    continue;
                }
                String key = parts[0].trim();
                String value = parts[1].trim();
                properties.setProperty(key, value);
            }
        }
        return answer;
    }
}

