/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import org.yaml.snakeyaml.Yaml;

public class YamlUtil {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Properties getPropertiesFromYamlResource(URL resource) {
        if (resource == null) return new Properties();
        try (InputStream yamlStream = resource.openStream();){
            Yaml yaml = new Yaml();
            SortedMap source = (SortedMap)yaml.loadAs(yamlStream, SortedMap.class);
            Properties properties = new Properties();
            if (source != null) {
                try {
                    properties.putAll(YamlUtil.getFlattenedMap(source));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Spring Boot configuration file %s is not formatted correctly. %s", resource.toString(), e.getMessage()));
                }
            }
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while reading Yaml resource from URL " + resource, e);
        }
    }

    private static Map<String, Object> getFlattenedMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        YamlUtil.buildFlattenedMap(result, source, null);
        return result;
    }

    private static void buildFlattenedMap(Map<String, Object> result, Map<String, Object> source, String path) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            Object value;
            String keyObject = entry.getKey();
            if (!(keyObject instanceof String)) {
                throw new IllegalArgumentException(String.format("Expected to find a key of type String but %s with content %s found.", keyObject.getClass(), keyObject.toString()));
            }
            String key = keyObject;
            if (path != null && path.trim().length() > 0) {
                key = key.startsWith("[") ? path + key : path + "." + key;
            }
            if ((value = entry.getValue()) instanceof Map) {
                Map map = (Map)value;
                YamlUtil.buildFlattenedMap(result, map, key);
                continue;
            }
            if (value instanceof Collection) {
                Collection collection = (Collection)value;
                int count = 0;
                for (Object object : collection) {
                    YamlUtil.buildFlattenedMap(result, Collections.singletonMap("[" + count++ + "]", object), key);
                }
                continue;
            }
            result.put(key, value != null ? value.toString() : "");
        }
    }
}

