/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.util;

import io.fabric8.maven.core.util.BuildLabelAnnotations;
import io.fabric8.maven.core.util.GitUtil;
import io.fabric8.maven.core.util.PrefixedLogger;
import io.fabric8.maven.docker.config.BuildImageConfiguration;
import io.fabric8.maven.docker.util.Logger;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.project.MavenProject;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;

public class BuildLabelUtil {
    private static String getDocumentationUrl(MavenProject project) {
        while (project != null) {
            Site site;
            DistributionManagement distributionManagement = project.getDistributionManagement();
            if (distributionManagement != null && (site = distributionManagement.getSite()) != null) {
                return site.getUrl();
            }
            project = project.getParent();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSchemaLabels(BuildImageConfiguration.Builder buildBuilder, MavenProject project, PrefixedLogger log) {
        String LABEL_SCHEMA_VERSION = "1.0";
        String GIT_REMOTE = "origin";
        String docURL = BuildLabelUtil.getDocumentationUrl(project);
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(BuildLabelAnnotations.BUILD_DATE.value(), LocalDateTime.now().toString());
        labels.put(BuildLabelAnnotations.NAME.value(), project.getName());
        labels.put(BuildLabelAnnotations.DESCRIPTION.value(), project.getDescription());
        if (docURL != null) {
            labels.put(BuildLabelAnnotations.USAGE.value(), docURL);
        }
        if (project.getUrl() != null) {
            labels.put(BuildLabelAnnotations.URL.value(), project.getUrl());
        }
        if (project.getOrganization() != null && project.getOrganization().getName() != null) {
            labels.put(BuildLabelAnnotations.VENDOR.value(), project.getOrganization().getName());
        }
        labels.put(BuildLabelAnnotations.VERSION.value(), project.getVersion());
        labels.put(BuildLabelAnnotations.SCHEMA_VERSION.value(), LABEL_SCHEMA_VERSION);
        try {
            Repository repository = GitUtil.getGitRepository(project.getBasedir());
            if (repository != null) {
                String commitID = GitUtil.getGitCommitId(repository);
                labels.put(BuildLabelAnnotations.VCS_REF.value(), commitID);
                String gitRemoteUrl = repository.getConfig().getString("remote", GIT_REMOTE, "url");
                if (gitRemoteUrl != null) {
                    labels.put(BuildLabelAnnotations.VCS_URL.value(), gitRemoteUrl);
                } else {
                    log.verbose(Logger.LogVerboseCategory.BUILD, "Could not detect any git remote", new Object[0]);
                }
            }
        }
        catch (IOException | NullPointerException | GitAPIException e) {
            log.error("Cannot extract Git information: " + e, e);
        }
        finally {
            buildBuilder.labels(labels);
        }
    }
}

