/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.service.kubernetes;

import io.fabric8.maven.core.service.BuildService;
import io.fabric8.maven.core.service.Fabric8ServiceException;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.maven.docker.service.BuildService;
import io.fabric8.maven.docker.service.ImagePullManager;
import io.fabric8.maven.docker.service.ServiceHub;
import java.util.Objects;

public class DockerBuildService
implements BuildService {
    private ServiceHub dockerServiceHub;
    private BuildService.BuildServiceConfig config;

    public DockerBuildService(ServiceHub dockerServiceHub, BuildService.BuildServiceConfig config) {
        Objects.requireNonNull(dockerServiceHub, "dockerServiceHub");
        Objects.requireNonNull(config, "config");
        this.dockerServiceHub = dockerServiceHub;
        this.config = config;
    }

    @Override
    public void build(ImageConfiguration imageConfig) throws Fabric8ServiceException {
        io.fabric8.maven.docker.service.BuildService dockerBuildService = this.dockerServiceHub.getBuildService();
        BuildService.BuildContext dockerBuildContext = this.config.getDockerBuildContext();
        ImagePullManager imagePullManager = this.config.getImagePullManager();
        try {
            dockerBuildService.buildImage(imageConfig, imagePullManager, dockerBuildContext);
            dockerBuildService.tagImage(imageConfig.getName(), imageConfig);
        }
        catch (Exception ex) {
            throw new Fabric8ServiceException("Error while trying to build the image", ex);
        }
    }

    @Override
    public void postProcess(BuildService.BuildServiceConfig config) {
    }
}

