/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.handler;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.maven.core.config.ResourceConfig;
import io.fabric8.maven.core.handler.PodTemplateHandler;
import io.fabric8.maven.core.util.kubernetes.KubernetesHelper;
import io.fabric8.maven.docker.config.ImageConfiguration;
import io.fabric8.openshift.api.model.DeploymentConfig;
import io.fabric8.openshift.api.model.DeploymentConfigBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpec;
import io.fabric8.openshift.api.model.DeploymentConfigSpecBuilder;
import io.fabric8.openshift.api.model.DeploymentConfigSpecFluent;
import io.fabric8.openshift.api.model.DeploymentStrategyFluent;
import java.util.List;

public class DeploymentConfigHandler {
    private final PodTemplateHandler podTemplateHandler;

    DeploymentConfigHandler(PodTemplateHandler podTemplateHandler) {
        this.podTemplateHandler = podTemplateHandler;
    }

    public DeploymentConfig getDeploymentConfig(ResourceConfig config, List<ImageConfiguration> images, Long openshiftDeployTimeoutSeconds, Boolean imageChangeTrigger, Boolean enableAutomaticTrigger, Boolean isOpenshiftBuildStrategy, List<String> generatedContainers) {
        DeploymentConfig deploymentConfig = ((DeploymentConfigBuilder)((DeploymentConfigBuilder)new DeploymentConfigBuilder().withMetadata(this.createDeploymentConfigMetaData(config))).withSpec(this.createDeploymentConfigSpec(config, images, openshiftDeployTimeoutSeconds, imageChangeTrigger, enableAutomaticTrigger, isOpenshiftBuildStrategy, generatedContainers))).build();
        return deploymentConfig;
    }

    private ObjectMeta createDeploymentConfigMetaData(ResourceConfig config) {
        return ((ObjectMetaBuilder)new ObjectMetaBuilder().withName(KubernetesHelper.validateKubernetesId(config.getControllerName(), "controller name"))).build();
    }

    private DeploymentConfigSpec createDeploymentConfigSpec(ResourceConfig config, List<ImageConfiguration> images, Long openshiftDeployTimeoutSeconds, Boolean imageChangeTrigger, Boolean enableAutomaticTrigger, Boolean isOpenshiftBuildStrategy, List<String> generatedContainers) {
        DeploymentConfigSpecBuilder specBuilder = new DeploymentConfigSpecBuilder();
        PodTemplateSpec podTemplateSpec = this.podTemplateHandler.getPodTemplate(config, images);
        ((DeploymentConfigSpecFluent.TriggersNested)((DeploymentConfigSpecBuilder)((DeploymentConfigSpecBuilder)specBuilder.withReplicas(Integer.valueOf(config.getReplicas()))).withTemplate(podTemplateSpec)).addNewTrigger().withType("ConfigChange")).endTrigger();
        if (openshiftDeployTimeoutSeconds != null && openshiftDeployTimeoutSeconds > 0L) {
            ((DeploymentConfigSpecFluent.StrategyNested)((DeploymentStrategyFluent.RollingParamsNested)((DeploymentConfigSpecFluent.StrategyNested)specBuilder.withNewStrategy().withType("Rolling")).withNewRollingParams().withTimeoutSeconds(openshiftDeployTimeoutSeconds)).endRollingParams()).endStrategy();
        }
        return specBuilder.build();
    }

    private void validateContainer(Container container) {
        if (container.getImage() == null) {
            throw new IllegalArgumentException("Container " + container.getName() + " has no Docker image configured. Please check your Docker image configuration (including the generators which are supposed to run)");
        }
    }
}

