/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.maven.core.access;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.maven.core.access.ClusterConfiguration;
import io.fabric8.maven.core.config.RuntimeMode;
import io.fabric8.maven.core.util.kubernetes.OpenshiftHelper;
import io.fabric8.maven.docker.util.Logger;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.OpenShiftClient;
import java.net.UnknownHostException;

public class ClusterAccess {
    private ClusterConfiguration clusterConfiguration;
    private KubernetesClient client;

    public ClusterAccess(ClusterConfiguration clusterConfiguration) {
        this.clusterConfiguration = clusterConfiguration;
        if (this.clusterConfiguration == null) {
            this.clusterConfiguration = new ClusterConfiguration.Builder().build();
        }
        this.client = null;
    }

    @Deprecated
    public ClusterAccess(String namespace) {
        ClusterConfiguration.Builder clusterConfigurationBuilder = new ClusterConfiguration.Builder();
        clusterConfigurationBuilder.namespace(namespace);
        this.clusterConfiguration = clusterConfigurationBuilder.build();
        this.client = null;
    }

    public ClusterAccess(ClusterConfiguration clusterConfiguration, KubernetesClient client) {
        this.clusterConfiguration = clusterConfiguration;
        this.client = client;
    }

    public <T extends KubernetesClient> T createDefaultClient(Logger log) {
        if (this.isOpenShift(log)) {
            return (T)this.createOpenShiftClient();
        }
        return (T)this.createKubernetesClient();
    }

    public KubernetesClient createKubernetesClient() {
        return new DefaultKubernetesClient(this.createDefaultConfig());
    }

    public OpenShiftClient createOpenShiftClient() {
        return new DefaultOpenShiftClient(this.createDefaultConfig());
    }

    private Config createDefaultConfig() {
        return this.clusterConfiguration.getConfig();
    }

    public String getNamespace() {
        return this.clusterConfiguration.getNamespace();
    }

    public boolean isOpenShiftImageStream(Logger log) {
        if (this.isOpenShift(log)) {
            OpenShiftClient openShiftClient = null;
            if (this.client == null) {
                openShiftClient = this.createOpenShiftClient();
            } else if (this.client instanceof OpenShiftClient) {
                openShiftClient = (OpenShiftClient)this.client;
            } else if (this.client.isAdaptable(OpenShiftClient.class).booleanValue()) {
                openShiftClient = (OpenShiftClient)this.client.adapt(OpenShiftClient.class);
            } else {
                return false;
            }
            return openShiftClient.supportsOpenShiftAPIGroup("image.openshift.io");
        }
        return false;
    }

    public boolean isOpenShift(Logger log) {
        try {
            return this.client == null ? OpenshiftHelper.isOpenShift(this.createKubernetesClient()) : OpenshiftHelper.isOpenShift(this.client);
        }
        catch (KubernetesClientException exp) {
            Throwable cause = exp.getCause();
            String prefix = cause instanceof UnknownHostException ? "Unknown host " : "";
            log.warn("Cannot access cluster for detecting mode: %s%s", new Object[]{prefix, cause != null ? cause.getMessage() : exp.getMessage()});
            return false;
        }
    }

    public RuntimeMode resolveRuntimeMode(RuntimeMode mode, Logger log) {
        if (mode == null) {
            mode = RuntimeMode.DEFAULT;
        }
        RuntimeMode resolvedMode = mode.isAuto() ? (this.isOpenShiftImageStream(log) ? RuntimeMode.openshift : RuntimeMode.kubernetes) : mode;
        return resolvedMode;
    }
}

